<?php
session_start();
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Login SISMAG - Futurista</title>
  <link href="https://fonts.googleapis.com/css2?family=Orbitron&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0; padding: 0;
      box-sizing: border-box;
      font-family: 'Orbitron', sans-serif;
    }

    body {
      background: linear-gradient(180deg, #0f2027, #203a43, #2c5364);
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 20px;
    }

    .login-container {
      background: rgba(255, 255, 255, 0.05);
      border: 1px solid rgba(255, 255, 255, 0.2);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      box-shadow: 0 8px 32px rgba(31, 38, 135, 0.37);
      border-radius: 20px;
      padding: 60px 30px;
      width: 100%;
      max-width: 400px;
      min-height: 600px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      color: white;
    }

    .login-container h2 {
      font-size: 26px;
      margin-bottom: 40px;
      text-align: center;
      color: #00ffff;
    }

    .form-group {
      width: 100%;
      margin-bottom: 25px;
    }

    input {
      width: 100%;
      padding: 15px;
      border-radius: 10px;
      border: none;
      outline: none;
      background: rgba(255, 255, 255, 0.2);
      color: white;
      font-size: 16px;
    }

    input::placeholder {
      color: #ddd;
    }

    button {
      width: 100%;
      padding: 15px;
      border: none;
      border-radius: 10px;
      background-color: #00bcd4;
      color: white;
      font-weight: bold;
      font-size: 16px;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }

    button:hover {
      background-color: #008c9e;
    }

    .erro {
      background-color: #ff4d4d;
      color: white;
      padding: 12px;
      margin-bottom: 20px;
      border-radius: 8px;
      text-align: center;
      width: 100%;
    }

    @media (max-width: 500px) {
      .login-container {
        padding: 40px 20px;
        min-height: 90vh;
      }
    }
  </style>
</head>
<body>

<div class="login-container">
  <h2>🔒Painel de Acesso</h2>

  <?php if (isset($_SESSION['erro_login'])): ?>
      <div class="erro"><?php echo $_SESSION['erro_login']; unset($_SESSION['erro_login']); ?></div>
  <?php endif; ?>

  <form action="validar_login.php" method="post" style="width: 100%;">
    <div class="form-group">
      <input type="text" name="usuario" placeholder="Id do Funcionário" required>
    </div>
    <div class="form-group">
      <input type="password" name="senha" placeholder="Senha" required>
    </div>
    <button type="submit">Entrar</button>
  </form>
</div>

</body>
</html>
