<?php
// =========================================================================
// marcar_presenca_seminario.php - Painel do Professor para Marcação de Presença
// =========================================================================

// --- CONFIGURAÇÃO DE CONEXÃO ---
define('DB_HOST', 'localhost');
define('DB_PORT', '3307');
define('DB_NAME', 'sismag');
define('DB_USER', 'root');
define('DB_PASS', '');

$pdo = null;
$mensagem = '';
$data_hoje = date('Y-m-d');
// IMPORTANTE: Este ID deve ser obtido da sessão do usuário logado!
$USUARIO_LOGADO_ID = 1; // ID do Professor (simulado)

try {
    $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=utf8";
    $pdo = new PDO($dsn, DB_USER, DB_PASS);
    // CORRIGIDO: PDO::ERRMODE_EXCEPTION (erro de constante resolvido)
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); 
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("ERRO DE CONEXÃO COM A BASE DE DADOS 'sismag': " . $e->getMessage());
}

// Busca o nome do usuário logado
$stmt_usuario = $pdo->prepare("SELECT nome FROM usuarios WHERE id = ?");
$stmt_usuario->execute([$USUARIO_LOGADO_ID]);
$usuario_logado = $stmt_usuario->fetch();
$nome_professor = $usuario_logado['nome'] ?? 'Professor Desconhecido';

// --- LÓGICA DE MARCAÇÃO DE PRESENÇA ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['marcar_presenca'])) {
    $seminario_id = (int)$_POST['seminario_id'];

    try {
        // 1. Verifica se a marcação está ABERTA (professor_id = 0)
        $stmt_status = $pdo->prepare("
            SELECT status_marcador 
            FROM presencas_seminario 
            WHERE seminario_id = ? AND data_presenca = ? AND professor_id = 0
        ");
        $stmt_status->execute([$seminario_id, $data_hoje]);
        $status_marcador = $stmt_status->fetchColumn();

        // CORRIGIDO: Verifica se o status é 'ABRIR' (o valor da sua base de dados)
        if ($status_marcador === 'ABRIR') { 
            
            // 2. Se estiver ABERTO, regista a presença do professor
            $stmt = $pdo->prepare("
                INSERT INTO presencas_seminario 
                (seminario_id, professor_id, data_presenca, data_registo) 
                VALUES (?, ?, ?, NOW()) 
                ON DUPLICATE KEY UPDATE 
                data_registo = NOW()
            ");
            $stmt->execute([$seminario_id, $USUARIO_LOGADO_ID, $data_hoje]);

            $mensagem = "<p style='color:green; font-weight:bold;'>Presença marcada com sucesso para hoje, " . date('d/m/Y') . "!</p>";
        } else {
            $mensagem = "<p style='color:red;'>Erro: A marcação de presença não está aberta no momento (Status: $status_marcador). Contacte a Subdireção Pedagógica.</p>";
        }
    } catch (PDOException $e) {
        // Se a presença já foi marcada (Duplicate Key)
        if ($e->getCode() == 23000) { 
             $mensagem = "<p style='color:orange;'>Atenção: A sua presença já foi registada para este seminário hoje.</p>";
        } else {
             $mensagem = "<p style='color:red;'>Erro no sistema: " . $e->getMessage() . "</p>";
        }
    }
}

// --- BUSCA SEMINÁRIOS ATIVOS E STATUS DE CONTROLO ---
$stmt_ativos = $pdo->prepare("
    SELECT s.id, s.nome_seminario, s.num_dias_seminario, p.status_marcador
    FROM seminarios s
    LEFT JOIN presencas_seminario p ON s.id = p.seminario_id 
        AND p.data_presenca = ? 
        AND p.professor_id = 0 -- Busca APENAS a linha de controlo do gestor
    WHERE ? BETWEEN s.data_inicio AND s.data_fim
    ORDER BY s.data_inicio ASC
");
$stmt_ativos->execute([$data_hoje, $data_hoje]);
$seminarios_ativos = $stmt_ativos->fetchAll();

// Busca as presenças já marcadas pelo professor para a data de hoje
$stmt_presencas = $pdo->prepare("
    SELECT 1 
    FROM presencas_seminario 
    WHERE professor_id = ? 
    AND data_presenca = ?
    AND professor_id != 0 
");
$stmt_presencas->execute([$USUARIO_LOGADO_ID, $data_hoje]);
$ja_marcou_hoje = $stmt_presencas->fetchColumn();

// Conta o total de presenças do professor (para informação)
$stmt_contagem = $pdo->prepare("
    SELECT COUNT(id) as total_presencas
    FROM presencas_seminario 
    WHERE professor_id = ? AND professor_id != 0
");
$stmt_contagem->execute([$USUARIO_LOGADO_ID]);
$total_presencas = $stmt_contagem->fetchColumn();
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Marcar Presença em Seminário</title>
    <style>
        /* ... Estilos CSS ... */
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 20px; }
        .container { max-width: 600px; margin: 0 auto; background-color: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 0 15px rgba(0,0,0,0.1); }
        h1 { text-align: center; color: #17a2b8; border-bottom: 3px solid #17a2b8; padding-bottom: 10px; margin-bottom: 25px; }
        .info { margin-bottom: 20px; padding: 10px; background-color: #e9ecef; border-left: 5px solid #17a2b8; }
        .seminario-box { border: 1px solid #ccc; padding: 15px; margin-bottom: 15px; border-radius: 6px; background-color: #fff; }
        button { 
            background-color: #17a2b8; 
            color: white; 
            padding: 10px 15px; 
            border: none; 
            border-radius: 4px; 
            cursor: pointer; 
            font-size: 1em;
            width: 100%;
        }
        button:hover { background-color: #138496; }
        .ja-marcado { background-color: #f0f0f0; color: #555; cursor: default; }
        .fechado { background-color: #dc3545; }
        /* ... Fim dos Estilos CSS ... */
    </style>
</head>
<body>
    <div class="container">
        <h1>Marcação de Presença - Seminários</h1>
        <div class="info">
            <p><strong>Professor:</strong> <?= htmlspecialchars($nome_professor) ?></p>
            <p><strong>Data de Hoje:</strong> <?= date('d/m/Y') ?></p>
            <p><strong>Total de Presenças Registadas:</strong> <span style="font-weight: bold;"><?= $total_presencas ?></span> dias</p>
        </div>

        <?= $mensagem ?>
        
        <?php if ($ja_marcou_hoje): ?>
            <p style="text-align: center; color: green; font-weight: bold; padding: 10px; border: 1px dashed green;">
                SUA PRESENÇA PARA HOJE JÁ FOI REGISTADA!
            </p>
        <?php endif; ?>

        <h2>Seminários Ativos Hoje</h2>
        <?php if (empty($seminarios_ativos)): ?>
            <p style="color: gray; text-align: center;">Nenhum seminário ativo ou programado para hoje.</p>
        <?php endif; ?>

        <?php foreach ($seminarios_ativos as $seminario): 
            $status_marcador = $seminario['status_marcador'] ?? 'FECHAR';
            // Usa 'ABRIR' para verificar o status
            $marcacacao_aberta = ($status_marcador === 'ABRIR');
        ?>
            <div class="seminario-box">
                <p style="font-weight: bold;"><?= htmlspecialchars($seminario['nome_seminario']) ?></p>
                <p>Total de Dias: <?= $seminario['num_dias_seminario'] ?></p>
                
                <form action="" method="post">
                    <input type="hidden" name="seminario_id" value="<?= $seminario['id'] ?>">
                    
                    <?php if ($ja_marcou_hoje): ?>
                        <button type="button" class="ja-marcado" disabled>Presença já marcada hoje</button>
                    <?php elseif ($marcacacao_aberta): ?>
                        <button type="submit" name="marcar_presenca">
                            CLIQUE PARA MARCAR PRESENÇA (Status: ABRIR)
                        </button>
                    <?php else: ?>
                           <button type="button" class="fechado" disabled>
                                Marcação Fechada (Status: FECHAR)
                            </button>
                    <?php endif; ?>
                </form>
            </div>
        <?php endforeach; ?>
    </div>
</body>
</html>