<?php<?php
session_start();
include 'conexao.php'; 

$mensagem = '';
$aluno_preenchido = null;
$modo_edicao = false;

// Verifica se um ID de aluno foi passado na URL (para edição)
if (isset($_GET['id'])) {
    $aluno_id_get = intval($_GET['id']);
    // Busca os dados do aluno com informações da turma
    $stmt_busca_aluno = $conn->prepare("SELECT a.*, t.nome AS nome_turma, t.classe, t.curso, t.turno 
                                         FROM alunos a 
                                         LEFT JOIN turmas t ON a.turma_id = t.id 
                                         WHERE a.id = ?");
    $stmt_busca_aluno->bind_param("i", $aluno_id_get);
    $stmt_busca_aluno->execute();
    $aluno_preenchido = $stmt_busca_aluno->get_result()->fetch_assoc();
    $stmt_busca_aluno->close();
    $modo_edicao = true; // Ativa o modo de edição
}

// Verifica se há mensagem de sucesso do redirecionamento
if (isset($_GET['sucesso'])) {
    $mensagem = "✅ Aluno matriculado com sucesso!";
} elseif (isset($_GET['sucesso_edicao'])) {
    $mensagem = "✅ Dados do aluno atualizados com sucesso!";
}

// Início da parte de processamento do formulário
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    $aluno_id = $_POST['aluno_id'] ?? null;
    $nome_completo = trim($_POST['nome_completo'] ?? '');
    $idade = $_POST['idade'] ?? null;
    $genero = $_POST['genero'] ?? null;
    $data_nascimento = $_POST['data_nascimento'] ?? null;
    $contacto = $_POST['contacto'] ?? null;
    $endereco = $_POST['endereco'] ?? null;
    $turma_id = $_POST['turma_id'] ?? null;
    $opcao_lingua = $_POST['opcao_lingua'] ?? 'Português';
    $vez = $_POST['vez'] ?? 1;
    $observacoes = $_POST['observacoes'] ?? null;
    $foto_nome = null;

    if (isset($_POST['salvar_edicao'])) {
        if ($aluno_id) {
            $foto_nome_atual = $aluno_preenchido['foto'] ?? null;
            if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
                $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
                $foto_nome_atual = uniqid('foto_') . '.' . $ext;
                move_uploaded_file($_FILES['foto']['tmp_name'], "fotos_alunos/$foto_nome_atual");
            }
            
            $stmt = $conn->prepare("UPDATE alunos SET nome = ?, idade = ?, genero = ?, data_nascimento = ?, contacto = ?, endereco = ?, foto = ?, opcao_lingua = ?, vez = ?, observacoes = ? WHERE id = ?");
            if ($stmt === false) { $mensagem = "❌ Erro na preparação da query: " . $conn->error; } else {
                $stmt->bind_param("sisssssisii", $nome_completo, $idade, $genero, $data_nascimento, $contacto, $endereco, $foto_nome_atual, $opcao_lingua, $vez, $observacoes, $aluno_id);
                if ($stmt->execute()) {
                    header('Location: matricular_aluno.php?id=' . $aluno_id . '&sucesso_edicao=1');
                    exit();
                } else { $mensagem = "❌ Erro ao atualizar dados do aluno: " . $stmt->error; }
                $stmt->close();
            }
        } else { $mensagem = "⚠️ Erro: ID do aluno não fornecido para a edição."; }
    }
    
    if (isset($_POST['matricular_normal']) || isset($_POST['matricular_ultimo'])) {
        $tipo_matricula = (isset($_POST['matricular_ultimo'])) ? 'ultimo' : 'normal';

        if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
            $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
            $foto_nome = uniqid('foto_') . '.' . $ext;
            move_uploaded_file($_FILES['foto']['tmp_name'], "fotos_alunos/$foto_nome");
        }

        $ano_letivo = null; $curso = null; $classe = null; $sala = null; $turno = null; $nome_turma = null;

        if ($turma_id) {
            $stmtTurma = $conn->prepare("SELECT nome, curso, classe, sala, turno, ano FROM turmas WHERE id = ?");
            $stmtTurma->bind_param("i", $turma_id);
            $stmtTurma->execute();
            $turma = $stmtTurma->get_result()->fetch_assoc();
            if ($turma) {
                $ano_letivo = $turma['ano']; $curso = $turma['curso']; $classe = $turma['classe'];
                $sala = $turma['sala']; $turno = $turma['turno']; $nome_turma = $turma['nome'];
            }
            $stmtTurma->close();
        }
        
        if ($nome_completo !== '' && empty($mensagem)) {
            $senha_gerada = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 8);
            $senha_hash = $senha_gerada;
            
            // 1. Insere o Aluno primeiro para obter o aluno_id
            $stmt_insert = $conn->prepare("INSERT INTO alunos (nome, idade, genero, data_nascimento, contacto, endereco, foto, senha, turma_id, classe, curso, nome_turma, turno, ano_letivo, opcao_lingua, vez, observacoes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            
            if ($stmt_insert === false) { $mensagem = "❌ Erro na preparação da query de inserção: " . $conn->error; } else {
                $stmt_insert->bind_param("sissssssissssssis", $nome_completo, $idade, $genero, $data_nascimento, $contacto, $endereco, $foto_nome, $senha_hash, $turma_id, $classe, $curso, $nome_turma, $turno, $ano_letivo, $opcao_lingua, $vez, $observacoes);
                
                if ($stmt_insert->execute()) {
                    $aluno_id = $stmt_insert->insert_id;
                    
                    $stmtCheck = $conn->prepare("SELECT id FROM matriculas WHERE aluno_id = ? AND turma_id = ? AND ano_letivo = ?");
                    $stmtCheck->bind_param("iis", $aluno_id, $turma_id, $ano_letivo);
                    $stmtCheck->execute();
                    $res = $stmtCheck->get_result();

                    if ($res->num_rows == 0) {
                        $stmtCount = $conn->prepare("SELECT COUNT(*) AS total FROM matriculas WHERE turma_id = ? AND ano_letivo = ?");
                        $stmtCount->bind_param("is", $turma_id, $ano_letivo);
                        $stmtCount->execute();
                        $total = $stmtCount->get_result()->fetch_assoc()['total'] ?? 0;

                        if ($total < 40) {
                            $data_matricula = date('Y-m-d');
                            $usuario_id = $_SESSION['usuario_id'] ?? 1;
                            $numero_processo = "PROC-" . $aluno_id . "-" . $ano_letivo;

                            // Início da Lógica de Numeração Corrigida
                            $novo_num = null;

                            if ($tipo_matricula === 'ultimo') {
                                // 2. Lógica para MATRICULAR ÚLTIMO
                                $stmtUltimo = $conn->prepare("SELECT MAX(CAST(numero AS UNSIGNED)) AS ultimo FROM matriculas WHERE turma_id = ? AND ano_letivo = ?");
                                $stmtUltimo->bind_param("is", $turma_id, $ano_letivo);
                                $stmtUltimo->execute();
                                $ultimo_num = $stmtUltimo->get_result()->fetch_assoc()['ultimo'] ?? 0;
                                $novo_num = str_pad($ultimo_num + 1, 3, '0', STR_PAD_LEFT);
                                // Não é necessário atualizar os outros números aqui.

                            } else {
                                // 3. Lógica para MATRICULAR NORMAL (Ordem Alfabética)
                                $matriculasExistentes = $conn->prepare("SELECT m.numero, a.nome, m.aluno_id FROM matriculas m JOIN alunos a ON m.aluno_id = a.id WHERE m.turma_id = ? AND m.ano_letivo = ? ORDER BY a.nome");
                                $matriculasExistentes->bind_param("is", $turma_id, $ano_letivo);
                                $matriculasExistentes->execute();
                                $resultado = $matriculasExistentes->get_result();
                                $lista_alunos = $resultado->fetch_all(MYSQLI_ASSOC);
                                
                                $posicao = 1; // A primeira posição é 1
                                $achou_posicao = false;

                                // Encontrar a posição de inserção (1-based)
                                foreach ($lista_alunos as $aluno_existente) {
                                    if (strcasecmp($nome_completo, $aluno_existente['nome']) < 0) {
                                        $achou_posicao = true;
                                        break; 
                                    }
                                    $posicao++;
                                }
                                
                                $novo_num = str_pad($posicao, 3, '0', STR_PAD_LEFT);

                                // Se achamos uma posição que não seja o final, precisamos atualizar os números sequentes
                                if ($achou_posicao || $posicao <= count($lista_alunos)) {
                                    foreach ($lista_alunos as $index => $aluno_existente) {
                                        // $index é 0-based. Se o aluno existente está na posição ou depois da nova inserção
                                        if ($index + 1 >= $posicao) {
                                            $num_atualizado = str_pad($index + 2, 3, '0', STR_PAD_LEFT); // Incrementa o número para dar lugar ao novo aluno
                                            
                                            $stmtUpdateNum = $conn->prepare("UPDATE matriculas SET numero = ? WHERE aluno_id = ? AND turma_id = ? AND ano_letivo = ?");
                                            $stmtUpdateNum->bind_param("siis", $num_atualizado, $aluno_existente['aluno_id'], $turma_id, $ano_letivo);
                                            $stmtUpdateNum->execute();
                                        }
                                    }
                                }
                            }
                            // Fim da Lógica de Numeração Corrigida

                            // 4. Insere a Matrícula
                            if ($novo_num) {
                                $stmtMatricula = $conn->prepare("INSERT INTO matriculas (aluno_id, turma_id, curso, classe, sala, turno, ano_letivo, numero, data_matricula, numero_processo, usuario_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                                if ($stmtMatricula === false) { $mensagem = "❌ Erro na preparação da query de matrícula: " . $conn->error; } else {
                                    $stmtMatricula->bind_param("iissssssssi", $aluno_id, $turma_id, $curso, $classe, $sala, $turno, $ano_letivo, $novo_num, $data_matricula, $numero_processo, $usuario_id);
                                    if ($stmtMatricula->execute()) {
                                        // 5. Atualiza o aluno com o número de matrícula e turma_id
                                        $stmtUpdateAluno = $conn->prepare("UPDATE alunos SET numero = ?, turma_id = ? WHERE id = ?");
                                        $stmtUpdateAluno->bind_param("sii", $novo_num, $turma_id, $aluno_id);
                                        $stmtUpdateAluno->execute();
                                        header('Location: matricular_aluno.php?sucesso=1');
                                        exit();
                                    } else { $mensagem = "❌ Erro ao inserir matrícula: " . $stmtMatricula->error; }
                                }
                            } else {
                                $mensagem = "❌ Erro interno na definição do número de matrícula.";
                            }
                        } else {
                            $mensagem = "⚠️ Erro: A turma selecionada já atingiu o limite de 40 alunos.";
                        }
                    } else {
                        $mensagem = "⚠️ Erro: O aluno já possui uma matrícula ativa nesta turma e ano letivo.";
                    }
                } else { $mensagem = "❌ Erro ao inserir aluno: " . $stmt_insert->error; }
            }
        }
    }
}


// Dropdowns
$turmas = $conn->query("SELECT id, classe, nome, curso, turno, ano FROM turmas ORDER BY classe, sala")->fetch_all(MYSQLI_ASSOC);

// NOVO: Busca todos os alunos para o select
$alunos = $conn->query("SELECT a.id, a.nome, t.classe, t.nome AS nome_turma FROM alunos a LEFT JOIN turmas t ON a.turma_id = t.id ORDER BY a.nome")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Matrícula de Aluno</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <style>
        /* ... (Estilos CSS) ... */
        * { box-sizing: border-box; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f0f2f5; }
        .topbar { background-color: #007bff; color: white; padding: 15px 20px; font-size: 20px; position: fixed; top: 0; left: 0; right: 0; z-index: 1000; }
        .sidebar { position: fixed; top: 60px; left: 0; width: 220px; height: 100%; background-color: #111827; padding-top: 20px; }
        .sidebar a { display: block; color: white; padding: 12px 20px; text-decoration: none; font-weight: 500; }
        .sidebar a:hover { background-color: #1e3a8a; }
        .main { margin-left: 220px; padding: 80px 30px 30px 30px; }
        .container { max-width: 900px; background: #fff; padding: 30px; border-radius: 12px; box-shadow: 0 8px 20px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #007bff; margin-bottom: 25px; }
        form { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .full { grid-column: 1 / 3; }
        label { display: block; font-weight: 600; margin-bottom: 5px; }
        input, select, textarea { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 8px; font-size: 14px; }
        input[type="file"] { padding: 6px; }
        button { background-color: #007bff; border: none; color: white; padding: 12px 20px; font-size: 16px; border-radius: 8px; cursor: pointer; transition: 0.3s; }
        button:hover { background-color: #0056b3; }
        .mensagem { margin-top: 20px; text-align: center; font-size: 16px; }
        .matricular-ultimo { background-color: #28a745; }
        .matricular-ultimo:hover { background-color: #218838; }
        .button-group { display: flex; justify-content: center; gap: 10px; }

        @media (max-width: 768px) {
            .sidebar { width: 100%; height: auto; position: relative; }
            .main { margin-left: 0; padding-top: 120px; }
            form { grid-template-columns: 1fr; }
            .full { grid-column: 1 / 2; }
            .button-group { flex-direction: column; }
        }
    </style>
</head>
<body>

<div class="topbar">
    📚 EMIL FRICK - Sistema de Gestão Escolar
</div>

<div class="sidebar">
    <a href="painel_secretaria_geral.php">🏠 Início</a>
    <a href="matricular_aluno.php">👨‍🎓 Alunos</a>
    <a href="cadastrar_turma1.php">🏫 Turmas</a>
    <a href="cadastrar_disciplina_anterior1.php">📘 Disciplinas</a>
    <a href="login.php">🔓 Sair</a>
</div>

<div class="main">
    <div class="container">
        <h2><?= $modo_edicao ? '✏️ Editar Dados do Aluno' : '📋 Matrícula de Aluno' ?></h2>
        <div class="full" style="text-align: center;">
            <?php if (!empty($mensagem)): ?>
                <div class="mensagem">
                    <?= $mensagem ?>
                </div>
            <?php endif; ?>
        </div>

        <form method="POST" action="" enctype="multipart/form-data" id="formMatricula">
            <input type="hidden" name="aluno_id" id="aluno_id" value="<?= htmlspecialchars($aluno_preenchido['id'] ?? '') ?>">

            <div class="full" style="margin-bottom: 20px;">
                <label>Buscar / Selecionar Aluno Existente:</label>
                <select id="aluno_select_completa" class="aluno_select">
                    <option value="">-- Selecione para preencher o formulário (Novo Aluno)</option>
                    <?php foreach ($alunos as $a): ?>
                        <option value="<?= $a['id'] ?>">
                            <?= htmlspecialchars($a['nome']) ?> (<?= $a['classe'] ? $a['classe'] . 'ª Classe' : 'Sem Turma' ?>)
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="full">
                <label>Nome Completo:</label>
                <input type="text" name="nome_completo" id="nome_completo" value="<?= htmlspecialchars($aluno_preenchido['nome'] ?? '') ?>" required>
            </div>

            <div>
                <label>Idade:</label>
                <select name="idade" id="idade" required>
                    <option value="">-- Selecione --</option>
                    <?php for ($i = 12; $i <= 60; $i++): ?>
                        <option value="<?= $i ?>" <?= ($aluno_preenchido['idade'] ?? '') == $i ? 'selected' : '' ?>>
                            <?= $i ?> anos
                        </option>
                    <?php endfor; ?>
                </select>
            </div>

            <div>
                <label>Género:</label>
                <select name="genero" id="genero" required>
                    <option value="">-- Selecione --</option>
                    <option value="Masculino" <?= ($aluno_preenchido['genero'] ?? '') == 'Masculino' ? 'selected' : '' ?>>Masculino</option>
                    <option value="Feminino" <?= ($aluno_preenchido['genero'] ?? '') == 'Feminino' ? 'selected' : '' ?>>Feminino</option>
                    <option value="Outro" <?= ($aluno_preenchido['genero'] ?? '') == 'Outro' ? 'selected' : '' ?>>Outro</option>
                </select>
            </div>

            <div>
                <label>Data de Nascimento:</label>
                <input type="date" name="data_nascimento" id="data_nascimento" value="<?= htmlspecialchars($aluno_preenchido['data_nascimento'] ?? '') ?>">
            </div>

            <div>
                <label>Contacto:</label>
                <input type="text" name="contacto" id="contacto" value="<?= htmlspecialchars($aluno_preenchido['contacto'] ?? '') ?>">
            </div>

            <div class="full">
                <label>Endereço:</label>
                <input type="text" name="endereco" id="endereco" value="<?= htmlspecialchars($aluno_preenchido['endereco'] ?? '') ?>">
            </div>

            <div class="full">
                <label>Foto do Aluno (Apenas para Matrícula/Nova Edição):</label>
                <input type="file" name="foto">
            </div>

            <div>
                <label>Opção de Língua:</label>
                <select name="opcao_lingua" id="opcao_lingua" required>
                    <option value="Português" <?= ($aluno_preenchido['opcao_lingua'] ?? '') == 'Português' ? 'selected' : '' ?>>Português</option>
                    <option value="Inglês" <?= ($aluno_preenchido['opcao_lingua'] ?? '') == 'Inglês' ? 'selected' : '' ?>>Inglês</option>
                    <option value="Francês" <?= ($aluno_preenchido['opcao_lingua'] ?? '') == 'Francês' ? 'selected' : '' ?>>Francês</option>
                </select>
            </div>

            <div>
                <label>Vez da Matrícula:</label>
                <select name="vez" id="vez" required>
                    <?php for ($i = 1; $i <= 5; $i++): ?>
                        <option value="<?= $i ?>" <?= ($aluno_preenchido['vez'] ?? '') == $i ? 'selected' : '' ?>>
                            <?= $i ?>ª Vez
                        </option>
                    <?php endfor; ?>
                </select>
            </div>
            
            <div class="full" id="turma_selecao_container">
                <?php if (!$modo_edicao): ?>
                    <label>Turma:</label>
                    <select name="turma_id" id="turma_select" required>
                        <option value="">-- Selecione a Turma --</option>
                        <?php foreach ($turmas as $t): ?>
                            <option value="<?= $t['id'] ?>" <?= ($aluno_preenchido['turma_id'] ?? '') == $t['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($t['classe']) ?> - <?= htmlspecialchars($t['curso']) ?> - <?= htmlspecialchars($t['nome']) ?> - <?= htmlspecialchars($t['turno']) ?> (<?= htmlspecialchars($t['ano']) ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php else: ?>
                    <label>Turma Atual:</label>
                    <input type="text" value="<?= htmlspecialchars($aluno_preenchido['classe'] . 'ª ' . $aluno_preenchido['nome_turma'] . ' - ' . $aluno_preenchido['curso'] . ' (' . $aluno_preenchido['turno'] . ')') ?>" disabled>
                    <input type="hidden" name="turma_id" id="turma_id_edicao" value="<?= htmlspecialchars($aluno_preenchido['turma_id'] ?? '') ?>">
                <?php endif; ?>
            </div>
            
            <div class="full">
                <label>Observações:</label>
                <textarea name="observacoes" id="observacoes" rows="4"><?= htmlspecialchars($aluno_preenchido['observacoes'] ?? '') ?></textarea>
            </div>


            <div class="full" style="text-align:center;">
                <div class="button-group">
                    <?php if ($modo_edicao): ?>
                        <button type="submit" name="salvar_edicao" id="btn_salvar_edicao">✅ Salvar Alterações</button>
                    <?php else: ?>
                        <button type="submit" name="matricular_normal" id="btn_matricular_normal">✅ Salvar / Matricular</button>
                        <button type="submit" name="matricular_ultimo" id="btn_matricular_ultimo" class="matricular-ultimo">➡️ Matricular último</button>
                    <?php endif; ?>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
$(function() {
    
    // Lista de turmas disponíveis (para o modo de volta à Matrícula)
    const turmasDisponiveis = <?= json_encode($turmas) ?>;

    // Função para atualizar os botões e o campo de turma
    function atualizarBotoes(isEdicao) {
        const buttonGroup = $(".button-group");
        buttonGroup.empty();
        
        if (isEdicao) {
            // Modo Edição
            $('#turma_selecao_container').html(`
                <label>Turma Atual:</label>
                <input type="text" value="${$('#aluno_id').val() ? 'Carregando...' : 'N/A'}" id="turma_display_edicao" disabled>
                <input type="hidden" name="turma_id" id="turma_id_edicao" value="">
            `);
            buttonGroup.append('<button type="submit" name="salvar_edicao" id="btn_salvar_edicao">✅ Salvar Alterações</button>');
            
        } else {
            // Modo Matrícula (Novo Aluno)
            
            // Recria a estrutura original de matrícula (Dropdown da Turma)
            $('#turma_selecao_container').html(`
                <label>Turma:</label>
                <select name="turma_id" id="turma_select" required>
                    <option value="">-- Selecione a Turma --</option>
                    ${turmasDisponiveis.map(t => `
                        <option value="${t.id}">${t.classe} - ${t.curso} - ${t.nome} - ${t.turno} (${t.ano})</option>
                    `).join('')}
                </select>
            `);

            buttonGroup.append('<button type="submit" name="matricular_normal" id="btn_matricular_normal">✅ Salvar / Matricular</button>');
            buttonGroup.append('<button type="submit" name="matricular_ultimo" id="btn_matricular_ultimo" class="matricular-ultimo">➡️ Matricular último</button>');
        }
    }
    
    // 1. Função para preencher os campos do formulário
    function preencherDadosAluno(dados) {
        // Preenche campos de texto
        $("#aluno_id").val(dados.id);
        $("#nome_completo").val(dados.nome);
        $("#data_nascimento").val(dados.data_nascimento);
        $("#contacto").val(dados.contacto);
        $("#endereco").val(dados.endereco);
        $("#observacoes").val(dados.observacoes);
        
        // Preenche campos de seleção
        $("#idade").val(dados.idade);
        $("#genero").val(dados.genero);
        $("#opcao_lingua").val(dados.opcao_lingua);
        $("#vez").val(dados.vez);
        
        // Atualiza a turma no modo Edição
        const turmaTexto = `${dados.classe ? dados.classe + 'ª ' : ''}${dados.nome_turma} - ${dados.curso} (${dados.turno})`;
        $('#turma_display_edicao').val(turmaTexto);
        $('#turma_id_edicao').val(dados.turma_id);
    }
    
    // 2. Listener para o campo SELECT
    $("#aluno_select_completa").on("change", function() {
        const alunoId = $(this).val();
        
        if (alunoId === "") {
            // Selecionou "Novo Aluno" - reseta o formulário
            $("#aluno_id").val("");
            $("#formMatricula")[0].reset();
            atualizarBotoes(false); // Volta para os botões de matrícula
            
        } else {
            // Selecionou um aluno existente - faz a busca via AJAX
            $.ajax({
                url: "buscar_aluno_dados.php",
                type: "GET",
                dataType: "json",
                data: { aluno_id: alunoId }, // Mudança no parâmetro GET para corresponder ao PHP
                success: function(response) {
                    if (response.length > 0) {
                        const dadosAluno = response[0]; // O buscar_aluno_dados.php ajustado retorna o objeto principal
                        
                        // Primeiro, atualiza os botões para modo Edição
                        atualizarBotoes(true);
                        
                        // Depois, preenche o formulário
                        // O campo 'data_nascimento_formatada' é usado, mas para evitar erro, usarei o original:
                        dadosAluno.data_nascimento = dadosAluno.data_nascimento_formatada || dadosAluno.data_nascimento;
                        
                        preencherDadosAluno(dadosAluno);
                    } else {
                        alert("Erro: Dados do aluno não encontrados.");
                        $("#aluno_select_completa").val(""); // Reseta a seleção
                    }
                },
                error: function(xhr, status, error) {
                    alert("Erro ao buscar dados do aluno: " + status + " " + error);
                }
            });
        }
    });

    // Garante que os botões corretos são exibidos no carregamento da página
    const modoEdicaoInicial = $("#aluno_id").val() !== "";
    if (modoEdicaoInicial) {
         // Se a página carregou em modo edição via URL (?id=...), apenas ajusta os botões
         atualizarBotoes(true);
         // Atualiza o texto da turma com o dado PHP pré-carregado
         const turmaDisplay = "<?= htmlspecialchars($aluno_preenchido['classe'] . 'ª ' . $aluno_preenchido['nome_turma'] . ' - ' . $aluno_preenchido['curso'] . ' (' . $aluno_preenchido['turno'] . ')') ?>";
         $('#turma_display_edicao').val(turmaDisplay);
         $('#turma_id_edicao').val("<?= $aluno_preenchido['turma_id'] ?? '' ?>");
    } else {
         atualizarBotoes(false);
    }

});
</script>

</body>
</html>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Matrícula de Aluno</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <style>
        * { box-sizing: border-box; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f0f2f5; }
        .topbar { background-color: #007bff; color: white; padding: 15px 20px; font-size: 20px; position: fixed; top: 0; left: 0; right: 0; z-index: 1000; }
        .sidebar { position: fixed; top: 60px; left: 0; width: 220px; height: 100%; background-color: #111827; padding-top: 20px; }
        .sidebar a { display: block; color: white; padding: 12px 20px; text-decoration: none; font-weight: 500; }
        .sidebar a:hover { background-color: #1e3a8a; }
        .main { margin-left: 220px; padding: 80px 30px 30px 30px; }
        .container { max-width: 900px; background: #fff; padding: 30px; border-radius: 12px; box-shadow: 0 8px 20px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #007bff; margin-bottom: 25px; }
        form { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .full { grid-column: 1 / 3; }
        label { display: block; font-weight: 600; margin-bottom: 5px; }
        input, select, textarea { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 8px; font-size: 14px; }
        input[type="file"] { padding: 6px; }
        button { background-color: #007bff; border: none; color: white; padding: 12px 20px; font-size: 16px; border-radius: 8px; cursor: pointer; transition: 0.3s; }
        button:hover { background-color: #0056b3; }
        .mensagem { margin-top: 20px; text-align: center; font-size: 16px; }
        .matricular-ultimo { background-color: #28a745; }
        .matricular-ultimo:hover { background-color: #218838; }
        .button-group { display: flex; justify-content: center; gap: 10px; }

        @media (max-width: 768px) {
            .sidebar { width: 100%; height: auto; position: relative; }
            .main { margin-left: 0; padding-top: 120px; }
            form { grid-template-columns: 1fr; }
            .full { grid-column: 1 / 2; }
            .button-group { flex-direction: column; }
        }
    </style>
</head>
<body>

<div class="topbar">
    📚 EMIL FRICK - Sistema de Gestão Escolar
</div>

<div class="sidebar">
    <a href="painel_secretaria_geral.php">🏠 Início</a>
    <a href="matricular_aluno.php">👨‍🎓 Alunos</a>
    <a href="cadastrar_turma1.php">🏫 Turmas</a>
    <a href="cadastrar_disciplina_anterior1.php">📘 Disciplinas</a>
    <a href="login.php">🔓 Sair</a>
</div>

<div class="main">
    <div class="container">
        <h2><?= $modo_edicao ? '✏️ Editar Dados do Aluno' : '📋 Matrícula de Aluno' ?></h2>
        <div class="full" style="text-align: center;">
            <?php if (!empty($mensagem)): ?>
                <div class="mensagem">
                    <?= $mensagem ?>
                </div>
            <?php endif; ?>
        </div>

        <form method="POST" action="" enctype="multipart/form-data" id="formMatricula">
            <input type="hidden" name="aluno_id" id="aluno_id" value="<?= htmlspecialchars($aluno_preenchido['id'] ?? '') ?>">

            <div class="full" style="margin-bottom: 20px;">
                <label>Buscar / Selecionar Aluno Existente:</label>
                <select id="aluno_select_completa" class="aluno_select">
                    <option value="">-- Selecione para preencher o formulário (Novo Aluno)</option>
                    <?php foreach ($alunos as $a): ?>
                        <option value="<?= $a['id'] ?>">
                            <?= htmlspecialchars($a['nome']) ?> (<?= $a['classe'] ? $a['classe'] . 'ª Classe' : 'Sem Turma' ?>)
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="full">
                <label>Nome Completo:</label>
                <input type="text" name="nome_completo" id="nome_completo" value="<?= htmlspecialchars($aluno_preenchido['nome'] ?? '') ?>" required>
            </div>

            <div>
                <label>Idade:</label>
                <select name="idade" id="idade" required>
                    <option value="">-- Selecione --</option>
                    <?php for ($i = 12; $i <= 60; $i++): ?>
                        <option value="<?= $i ?>" <?= ($aluno_preenchido['idade'] ?? '') == $i ? 'selected' : '' ?>>
                            <?= $i ?> anos
                        </option>
                    <?php endfor; ?>
                </select>
            </div>

            <div>
                <label>Género:</label>
                <select name="genero" id="genero" required>
                    <option value="">-- Selecione --</option>
                    <option value="Masculino" <?= ($aluno_preenchido['genero'] ?? '') == 'Masculino' ? 'selected' : '' ?>>Masculino</option>
                    <option value="Feminino" <?= ($aluno_preenchido['genero'] ?? '') == 'Feminino' ? 'selected' : '' ?>>Feminino</option>
                    <option value="Outro" <?= ($aluno_preenchido['genero'] ?? '') == 'Outro' ? 'selected' : '' ?>>Outro</option>
                </select>
            </div>

            <div>
                <label>Data de Nascimento:</label>
                <input type="date" name="data_nascimento" id="data_nascimento" value="<?= htmlspecialchars($aluno_preenchido['data_nascimento'] ?? '') ?>">
            </div>

            <div>
                <label>Contacto:</label>
                <input type="text" name="contacto" id="contacto" value="<?= htmlspecialchars($aluno_preenchido['contacto'] ?? '') ?>">
            </div>

            <div class="full">
                <label>Endereço:</label>
                <input type="text" name="endereco" id="endereco" value="<?= htmlspecialchars($aluno_preenchido['endereco'] ?? '') ?>">
            </div>

            <div class="full">
                <label>Foto do Aluno (Apenas para Matrícula/Nova Edição):</label>
                <input type="file" name="foto">
            </div>

            <div>
                <label>Opção de Língua:</label>
                <select name="opcao_lingua" id="opcao_lingua" required>
                    <option value="Português" <?= ($aluno_preenchido['opcao_lingua'] ?? '') == 'Português' ? 'selected' : '' ?>>Português</option>
                    <option value="Inglês" <?= ($aluno_preenchido['opcao_lingua'] ?? '') == 'Inglês' ? 'selected' : '' ?>>Inglês</option>
                    <option value="Francês" <?= ($aluno_preenchido['opcao_lingua'] ?? '') == 'Francês' ? 'selected' : '' ?>>Francês</option>
                </select>
            </div>

            <div>
                <label>Vez da Matrícula:</label>
                <select name="vez" id="vez" required>
                    <?php for ($i = 1; $i <= 5; $i++): ?>
                        <option value="<?= $i ?>" <?= ($aluno_preenchido['vez'] ?? '') == $i ? 'selected' : '' ?>>
                            <?= $i ?>ª Vez
                        </option>
                    <?php endfor; ?>
                </select>
            </div>
            
            <div class="full" id="turma_selecao_container">
                <?php if (!$modo_edicao): ?>
                    <label>Turma:</label>
                    <select name="turma_id" id="turma_select" required>
                        <option value="">-- Selecione a Turma --</option>
                        <?php foreach ($turmas as $t): ?>
                            <option value="<?= $t['id'] ?>" <?= ($aluno_preenchido['turma_id'] ?? '') == $t['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($t['classe']) ?> - <?= htmlspecialchars($t['curso']) ?> - <?= htmlspecialchars($t['nome']) ?> - <?= htmlspecialchars($t['turno']) ?> (<?= htmlspecialchars($t['ano']) ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php else: ?>
                    <label>Turma Atual:</label>
                    <input type="text" value="<?= htmlspecialchars($aluno_preenchido['classe'] . 'ª ' . $aluno_preenchido['nome_turma'] . ' - ' . $aluno_preenchido['curso'] . ' (' . $aluno_preenchido['turno'] . ')') ?>" disabled>
                    <input type="hidden" name="turma_id" id="turma_id_edicao" value="<?= htmlspecialchars($aluno_preenchido['turma_id'] ?? '') ?>">
                <?php endif; ?>
            </div>
            
            <div class="full">
                <label>Observações:</label>
                <textarea name="observacoes" id="observacoes" rows="4"><?= htmlspecialchars($aluno_preenchido['observacoes'] ?? '') ?></textarea>
            </div>


            <div class="full" style="text-align:center;">
                <div class="button-group">
                    <?php if ($modo_edicao): ?>
                        <button type="submit" name="salvar_edicao" id="btn_salvar_edicao">✅ Salvar Alterações</button>
                    <?php else: ?>
                        <button type="submit" name="matricular_normal" id="btn_matricular_normal">✅ Salvar / Matricular</button>
                        <button type="submit" name="matricular_ultimo" id="btn_matricular_ultimo" class="matricular-ultimo">➡️ Matricular último</button>
                    <?php endif; ?>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
$(function() {
    
    // Lista de turmas disponíveis (para o modo de volta à Matrícula)
    const turmasDisponiveis = <?= json_encode($turmas) ?>;

    // Função para atualizar os botões e o campo de turma
    function atualizarBotoes(isEdicao) {
        const buttonGroup = $(".button-group");
        buttonGroup.empty();
        
        if (isEdicao) {
            // Modo Edição
            $('#turma_selecao_container').html(`
                <label>Turma Atual:</label>
                <input type="text" value="${$('#aluno_id').val() ? 'Carregando...' : 'N/A'}" id="turma_display_edicao" disabled>
                <input type="hidden" name="turma_id" id="turma_id_edicao" value="">
            `);
            buttonGroup.append('<button type="submit" name="salvar_edicao" id="btn_salvar_edicao">✅ Salvar Alterações</button>');
            
        } else {
            // Modo Matrícula (Novo Aluno)
            
            // Recria a estrutura original de matrícula (Dropdown da Turma)
            $('#turma_selecao_container').html(`
                <label>Turma:</label>
                <select name="turma_id" id="turma_select" required>
                    <option value="">-- Selecione a Turma --</option>
                    ${turmasDisponiveis.map(t => `
                        <option value="${t.id}">${t.classe} - ${t.curso} - ${t.nome} - ${t.turno} (${t.ano})</option>
                    `).join('')}
                </select>
            `);

            buttonGroup.append('<button type="submit" name="matricular_normal" id="btn_matricular_normal">✅ Salvar / Matricular</button>');
            buttonGroup.append('<button type="submit" name="matricular_ultimo" id="btn_matricular_ultimo" class="matricular-ultimo">➡️ Matricular último</button>');
        }
    }
    
    // 1. Função para preencher os campos do formulário
    function preencherDadosAluno(dados) {
        // Preenche campos de texto
        $("#aluno_id").val(dados.id);
        $("#nome_completo").val(dados.nome);
        $("#data_nascimento").val(dados.data_nascimento);
        $("#contacto").val(dados.contacto);
        $("#endereco").val(dados.endereco);
        $("#observacoes").val(dados.observacoes);
        
        // Preenche campos de seleção
        $("#idade").val(dados.idade);
        $("#genero").val(dados.genero);
        $("#opcao_lingua").val(dados.opcao_lingua);
        $("#vez").val(dados.vez);
        
        // Atualiza a turma no modo Edição
        const turmaTexto = `${dados.classe ? dados.classe + 'ª ' : ''}${dados.nome_turma} - ${dados.curso} (${dados.turno})`;
        $('#turma_display_edicao').val(turmaTexto);
        $('#turma_id_edicao').val(dados.turma_id);
    }
    
    // 2. Listener para o campo SELECT
    $("#aluno_select_completa").on("change", function() {
        const alunoId = $(this).val();
        
        if (alunoId === "") {
            // Selecionou "Novo Aluno" - reseta o formulário
            $("#aluno_id").val("");
            $("#formMatricula")[0].reset();
            atualizarBotoes(false); // Volta para os botões de matrícula
            
        } else {
            // Selecionou um aluno existente - faz a busca via AJAX
            $.ajax({
                url: "buscar_aluno_dados.php",
                type: "GET",
                dataType: "json",
                data: { term: alunoId, full_id: true }, // full_id indica que estamos buscando por ID
                success: function(response) {
                    if (response.length > 0) {
                        const dadosAluno = response[0].dados; // O buscar_aluno_dados.php precisa ser ajustado (veja o próximo passo)
                        
                        // Primeiro, atualiza os botões para modo Edição
                        atualizarBotoes(true);
                        
                        // Depois, preenche o formulário
                        preencherDadosAluno(dadosAluno);
                    } else {
                        alert("Erro: Dados do aluno não encontrados.");
                        $("#aluno_select_completa").val(""); // Reseta a seleção
                    }
                },
                error: function(xhr, status, error) {
                    alert("Erro ao buscar dados do aluno: " + status + " " + error);
                }
            });
        }
    });

    // Garante que os botões corretos são exibidos no carregamento da página
    const modoEdicaoInicial = $("#aluno_id").val() !== "";
    if (modoEdicaoInicial) {
         // Se a página carregou em modo edição via URL (?id=...), apenas ajusta os botões
         atualizarBotoes(true);
         // Atualiza o texto da turma com o dado PHP pré-carregado
         const turmaDisplay = "<?= htmlspecialchars($aluno_preenchido['classe'] . 'ª ' . $aluno_preenchido['nome_turma'] . ' - ' . $aluno_preenchido['curso'] . ' (' . $aluno_preenchido['turno'] . ')') ?>";
         $('#turma_display_edicao').val(turmaDisplay);
         $('#turma_id_edicao').val("<?= $aluno_preenchido['turma_id'] ?? '' ?>");
    } else {
         atualizarBotoes(false);
    }

});
</script>

</body>
</html>