<?php
// Inicia a sessão
session_start();

// Garanta que este arquivo existe e a conexão funciona.
// A linha 'session_start()' DEVERIA ser removida daqui se você a adicionou no conexao.php.
include 'conexao.php'; 

// =================================================================================
// 1. LÓGICA DE CONTROLE DE SESSÃO
// =================================================================================
$usuario_id = (int)($_SESSION['usuario']['id'] ?? $_SESSION['usuario']['id_funcionario'] ?? 0);

$perfil = $_SESSION['usuario']['perfil'] ?? '';

$is_professor = strtoupper(trim($perfil)) === 'PROFESSOR';
$is_simulating = $_SESSION['simulando'] ?? false; // Flag para saber se é o gestor

$id_para_consulta = $usuario_id; 

if (!$is_professor && !$is_simulating) {
    header('Location: login.php');
    exit;
}
if ($usuario_id <= 0) { 
    header('Location: login.php');
    exit;
}

// ... Busca do Nome do Professor ...
$nome_professor = '';
$sqlNome = "SELECT nome FROM usuarios WHERE id = ? LIMIT 1";
$stmt = $conn->prepare($sqlNome);
if ($stmt) {
    $stmt->bind_param("i", $usuario_id);
    $stmt->execute();
    $resNome = $stmt->get_result();
    if ($resNome && $resNome->num_rows === 1) {
        $rowNome = $resNome->fetch_assoc();
        $nome_professor = $rowNome['nome'];
    }
    $stmt->close();
}

// Ano lectivo e Variáveis Estáticas
$ano_lectivo_atual = '2025/2026';
$nome_republica = "REPÚBLICA DE ANGOLA";
$nome_governo = "GOVERNO PROVINCIAL DE BENGUELA";
$nome_gabinete = "GABINETE PROVINCIAL DA EDUCAÇÃO";
$nome_escola = "COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA";
$nome_sub_diretor = "Anacleto Domingos de Oliveira Cachiuenjo";
$localidade = "CATUMBELA";

// Variáveis dinâmicas da turma (inicializadas)
$classe_dinamica = '';
$nome_turma_dinamica = '';
$curso_area_dinamica = '';
$turno_dinamico = '';
$sala_dinamica = '';
$turma_completa = '';

// =================================================================================
// 2. INCLUSÃO DA LÓGICA DE SALVAR NOTAS
// =================================================================================
// >>>>>>>>> ESTA LINHA CAUSAVA O ERRO DE "REQUISIÇÃO INVÁLIDA" <<<<<<<<<<
// include_once 'salvar_notas.php'; 
// >>>>>>>>> DEVE SER REMOVIDA DA PÁGINA DE VISUALIZAÇÃO (GET) <<<<<<<<<<

// =================================================================================
// 3. FILTROS E BUSCA DE DADOS
// ... (O restante da lógica de busca de Turmas, Disciplinas e Alunos permanece inalterado) ...

$turma_id = $_GET['turma_id'] ?? null;
$disciplina_id = $_GET['disciplina_id'] ?? null;
$trimestre_selecionado = $_GET['trimestre'] ?? null;
$nome_disciplina = '';
$nome_turma_selecionada = '';
$prazo_fechado = false;

// Busca de Turmas
$turmas = [];
$sqlTurmas = "
    SELECT DISTINCT t.id, t.nome, t.classe, t.sala, t.curso, t.turno
    FROM turmas t
    INNER JOIN atribuicoes a ON t.id = a.turma_id
    WHERE a.professor_id = ?
    ORDER BY t.classe, t.nome
";
$stmt = $conn->prepare($sqlTurmas);
$stmt->bind_param("i", $id_para_consulta); 
$stmt->execute();
$turmas_res = $stmt->get_result();
$turmas = [];
while ($row = $turmas_res->fetch_assoc()) {
    $partes = [];
    if ($row['classe']) $partes[] = $row['classe'];
    if ($row['nome']) $partes[] = $row['nome'];
    if ($row['curso']) $partes[] = $row['curso'];
    if ($row['turno']) $partes[] = $row['turno'];
    if ($row['sala']) $partes[] = $row['sala'];
    $row['descricao_formatada'] = implode('-', $partes); 
    $turmas[] = $row;
}
$stmt->close();

// Busca de Disciplinas
$disciplinas = [];
if ($turma_id) {
    $sqlDisciplinas = "
        SELECT DISTINCT d.id, d.nome
        FROM atribuicoes a
        INNER JOIN disciplinas d ON a.turma_id = a.turma_id AND a.disciplina_id = d.id
        WHERE a.professor_id = ? AND a.turma_id = ?
        ORDER BY d.nome
    ";
    $stmt = $conn->prepare($sqlDisciplinas);
    $stmt->bind_param("ii", $id_para_consulta, $turma_id);
    $stmt->execute();
    $disciplinas_res = $stmt->get_result();
    while ($disciplina = $disciplinas_res->fetch_assoc()) {
        $disciplinas[] = $disciplina;
    }
    $stmt->close();
}

// Busca do nome da disciplina
if ($disciplina_id) {
    $sqlNomeDisciplina = "SELECT nome FROM disciplinas WHERE id = ?";
    $stmt = $conn->prepare($sqlNomeDisciplina);
    $stmt->bind_param("i", $disciplina_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows > 0) {
        $row = $res->fetch_assoc();
        $nome_disciplina = $row['nome'];
    }
    $stmt->close();
}

// Detalhes da Turma para o Cabeçalho
if ($turma_id) {
    foreach ($turmas as $turma) {
        if ($turma['id'] == $turma_id) {
            $nome_turma_selecionada = $turma['descricao_formatada'];
            
            $partes_turma = explode('-', $nome_turma_selecionada);
            $classe_dinamica = $partes_turma[0] ?? ''; 
            $nome_turma_dinamica = $partes_turma[1] ?? ''; 
            $curso_area_dinamica = $partes_turma[2] ?? ''; 
            $turno_dinamico = $partes_turma[3] ?? ''; 
            $sala_dinamica = $partes_turma[4] ?? ''; 

            $turma_completa = "Turma: " . $nome_turma_dinamica . " - " . $turno_dinamico . " sala nº " . $sala_dinamica;
            
            break;
        }
    }
}

$alunos = [];
$notas_por_aluno = [];
if ($turma_id && $disciplina_id && $trimestre_selecionado) {
    // Verifica se o trimestre já foi fechado 
    $sqlCheckFecho = "SELECT COUNT(*) 
        FROM fecho_trimestre 
        WHERE turma_id = ? AND disciplina_id = ? AND trimestre = ?";
    $stmtCheckFecho = $conn->prepare($sqlCheckFecho);
    $stmtCheckFecho->bind_param("iii", $turma_id, $disciplina_id, $trimestre_selecionado);
    $stmtCheckFecho->execute();
    $count = $stmtCheckFecho->get_result()->fetch_row()[0];
    $stmtCheckFecho->close();
    $prazo_fechado = ($count > 0);

    // Buscar alunos da turma
    $sqlAlunos = "SELECT id, nome FROM alunos WHERE turma_id = ? ORDER BY nome";
    $stmtAlunos = $conn->prepare($sqlAlunos);
    $stmtAlunos->bind_param("i", $turma_id);
    $stmtAlunos->execute();
    $alunos_res = $stmtAlunos->get_result();
    $alunos_data = $alunos_res->fetch_all(MYSQLI_ASSOC);
    $stmtAlunos->close();

    // Buscar notas já lançadas
    $aluno_ids = array_column($alunos_data, 'id');
    if (!empty($aluno_ids)) {
        $in_clause = str_repeat('?,', count($aluno_ids) - 1) . '?';
        // Buscamos todas as notas para que o JavaScript possa calcular o MFD e MF
        $sqlNotas = "SELECT * FROM notas 
            WHERE aluno_id IN ($in_clause) AND disciplina_id = ? AND turma_id = ?";
        $params_types = str_repeat('i', count($aluno_ids)) . 'ii';
        $params = array_merge($aluno_ids, [$disciplina_id, $turma_id]);

        $stmtNotas = $conn->prepare($sqlNotas);
        // O array_merge precisa ser desempacotado com '...'
        $stmtNotas->bind_param($params_types, ...$params); 
        $stmtNotas->execute();
        $resultNotas = $stmtNotas->get_result();
        while ($nota = $resultNotas->fetch_assoc()) {
            $notas_por_aluno[$nota['aluno_id']][$nota['trimestre']] = $nota;
        }
        $stmtNotas->close();
    }

    $alunos = $alunos_data;
}

// Mensagens de feedback
$mensagem_sucesso = $_SESSION['mensagem_sucesso'] ?? '';
$mensagem_erro = $_SESSION['mensagem_erro'] ?? '';
unset($_SESSION['mensagem_sucesso'], $_SESSION['mensagem_erro']);

// Variáveis injetadas no JavaScript
$notas_js = json_encode($notas_por_aluno);
$trimestre_js = (int)($trimestre_selecionado ?? 0);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lançar Notas - Mini Pauta</title>
    
    <link rel="stylesheet" href="css/all.min.css">
    <link rel="stylesheet" href="css/inter.css">
    <script src="js/tailwindcss.js"></script>
    <script src="js/chart.umd.min.js"></script>
    <style>
/* Estilos de interface (desktop/mobile) - Início */

.sidebar { transition: transform 0.3s; transform: translateX(-100%); z-index: 999; }
.sidebar.active { transform: translateX(0); }
.overlay { position: fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:998; display:none; }
.overlay.active { display:block; }

@media (min-width: 768px) {
    .sidebar { transform: translateX(0); }
    .content { margin-left: 16rem; }
    .overlay { display: none !important; }
}

input[type="number"]::-webkit-outer-spin-button,
input[type="number"]::-webkit-inner-spin-button { -webkit-appearance: none; margin: 0; }
input[type="number"] { -moz-appearance: textfield; }

/* Largura padrão dos inputs de nota na tela */
.nota-input {
    width: 50px; /* Mobile */
    font-size: 0.8rem;
    border-radius: 4px; 
    background-color: white; 
}
.mac-input {
     background-color: #f3f4f6; 
     font-weight: bold;
}

@media (min-width: 768px) {
    .nota-input {
        width: 80px; /* Desktop */
        font-size: 1rem;
    }
    /* Removida a regra de min-width para notas na tela */
}

/* Melhoria de Design para a Tabela (Desktop/Mobile) */
.print-table-container table {
    border-collapse: separate; 
    border-spacing: 0;
}
.print-table-container th, .print-table-container td {
    padding: 8px 10px;
    border-bottom: 1px solid #e5e7eb; 
    border-right: 1px solid #e5e7eb;
    text-align: center;
}
.print-table-container th:first-child, .print-table-container td:first-child {
    border-left: 1px solid #e5e7eb;
}
.print-table-container tr:last-child td {
    border-bottom: 1px solid #e5e7eb;
}
.print-table-container thead {
    background-color: #1e3a8a; 
    color: white;
}
.print-table-container tbody tr:hover {
    background-color: #f9f9f9;
}

/* CORREÇÕES ESPECÍFICAS PARA NOME DO ALUNO (TELA) */
.coluna-nome-aluno-tela {
    min-width: 180px; 
    text-align: left !important;
    /* Certificar que estas regras NÃO estejam ativas na tela se estiverem causando reticências: */
    /* white-space: nowrap; 
    overflow: hidden; 
    text-overflow: ellipsis; */
}

/* Células de Notas Calculadas (Estilo Padrão, será sobrescrito se tiver valor) */
.nota-calculada { background-color: #e0f2f1; font-weight: bold; color: #0f766e; } /* MT, MFD, MEC */
.nota-final-calc { background-color: #fef2f2; font-weight: bold; color: #b91c1c; } /* MF */

/* === ESTILOS DE NOTAS FINAIS === */
.nota-aprovada {
    background-color: #d1fae5 !important; /* Verde muito claro */
    color: #065f46 !important; /* Verde escuro */
    font-weight: bold;
}
.nota-reprovada {
    background-color: #fecaca !important; /* Vermelho muito claro */
    color: #991b1b !important; /* Vermelho escuro */
    font-weight: bold;
}

.estado-final-aprovado { background-color: #d1fae5; color: #065f46; font-weight: bold; }
.estado-final-reprovado { background-color: #fecaca; color: #991b1b; font-weight: bold; }
.estado-final-incompleto { background-color: #fef3c7; color: #b45309; font-weight: bold; }

/* Estilos de interface (desktop/mobile) - Fim */
/* ------------------------------------------- */


/* ================================================= */
/* ESTILOS DE IMPRESSÃO (A4) - OTIMIZAÇÃO MAXIMIZADA */
/* ================================================= */
@media print {
    @page {
        size: A4 portrait; 
        margin: 5mm; 
    }

    .print-hidden, .sidebar, header, nav, .overlay, .form-filtros, .btn-salvar-notas {
        display: none !important;
    }
    
    body, main, .content {
        margin: 0 !important;
        padding: 0 !important;
        min-height: initial !important;
        background-color: white !important;
    }

    .print-table-container {
        box-shadow: none !important;
        border: none !important;
    }
    table {
        width: 100% !important;
        border-collapse: collapse !important;
        font-size: 8pt; 
        table-layout: fixed; /* Essencial para que as larguras fixas funcionem */
    }
    th, td {
        border: 1px solid #000 !important;
        padding: 1px 3px !important; 
        color: #000 !important; 
        background-color: white !important; /* Branco na impressão */
        height: 15px; 
    }
    thead {
        -webkit-print-color-adjust: exact;
        color-adjust: exact;
        background-color: #d1d5db !important; 
        color: #000 !important;
    }
    
    /* Remove a cor da célula na impressão e mostra apenas o texto */
    .nota-aprovada, .nota-reprovada, .nota-calculada, .nota-final-calc {
        background-color: white !important;
        color: #000 !important;
    }

    /* --- AJUSTES DE LARGURA DAS COLUNAS (MAXIMIZAÇÃO DO NOME) --- */

    /* 1. COLUNA N.º DE ORDEM (Assumindo a 1ª coluna) */
    td:nth-child(1), th:nth-child(1) {
        width: 3% !important; 
        text-align: center !important;
    }

    /* 2. COLUNA DO NOME DO ALUNO (2ª COLUNA) - MAXIMIZADA E CORRIGIDA */
    .coluna-nome-aluno {
        width: 60% !important; /* MAXIMIZADO para 60% */
        min-width: 150px;
        text-align: left !important;
        padding-left: 5px !important;
        
        /* CORREÇÃO: Força linha única e elimina as reticências */
        white-space: nowrap; /* Garante que o nome fique em uma única linha */
        overflow: hidden; /* Oculta o que excede a largura (sem reticências) */
        text-overflow: clip; /* Garante que o corte não seja com reticências */
    }
    .coluna-nome-aluno-header {
        text-align: left !important;
        padding-left: 5px !important;
    } 


    /* Ocultar inputs e colunas de exame/mfd na impressão (Manter apenas o valor) */
    .nota-input { display: none !important; }

    /* CORREÇÃO/REFORÇO: Mostra o valor de nota a partir do data-nota-valor na impressão */
    .print-value::before { 
        content: attr(data-nota-valor); 
        display: block; 
        text-align: center; /* Centraliza o valor que aparece na impressão */
    }
    
    /* 3. COLUNAS DE NOTAS TRIMESTRAIS (MAC, NPT, MT - 3ª, 4ª, 5ª) - REDUZIDAS */
    td:nth-child(3), td:nth-child(4), td:nth-child(5) {
        width: 3% !important; /* REDUZIDO para 3% (Total 9%) */
    }
    
    /* 4. Colunas finais (MFD/NEO/NEE/MEC/MF/ESTADO - 6ª a 11ª) - REDUZIDAS */
    td:nth-child(6), td:nth-child(7), td:nth-child(8), td:nth-child(9), td:nth-child(10), td:nth-child(11) {
        width: 4% !important; /* REDUZIDO para 4% (Total 24%) */
    }
    
    /* 5. Coluna OBS. (12ª coluna) */
    td:nth-child(12), th:nth-child(12) {
        width: 4% !important; /* 4% restante */
    }
    
    /* --- CABEÇALHO --- */
    .print-header {
        display: block !important;
        text-align: center;
        margin-bottom: 5px;
    }
    .header-insignia img { width: 40px; height: auto; margin: 0 auto; display: block; }
    .header-text { line-height: 1.1; font-size: 8pt; margin-bottom: 3px; }
    .header-text p { margin: 1px 0; }
    .header-title { font-weight: bold; margin: 3px 0 3px 0; font-size: 9pt; }
    .header-info { text-align: left; font-size: 8pt; width: 100%; margin-top: 3px; display: table; }
    .header-info p { margin: 1px 0; display: table-row; }
    .header-info .info-label { font-weight: normal; white-space: nowrap; display: table-cell; padding-right: 5px; }
    .header-info .info-value { font-weight: bold; display: table-cell; }
    hr { margin: 5px 0 !important;}

    /* --- RODAPÉ DE ASSINATURAS --- */
    .print-footer {
        display: block !important;
        margin-top: 10px;
        width: 100%;
        font-size: 8pt;
    }
    .footer-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px; 
        width: 90%; 
        margin: 0 auto;
        text-align: center;
    }
    .assinatura-linha {
        margin-top: 20px;
        border-bottom: 1px solid #000;
        width: 100%;
        height: 1px;
    }
    .nome-assinado {
        margin-top: 2px;
        font-weight: bold;
    }
    .data-catumbela {
        margin-top: 5px;
        font-size: 8pt;
    }
    .data-catumbela span {
        border-bottom: 1px solid #000;
        padding: 0 5px; 
    }
}
</style>
</head>
<body class="bg-gray-100 min-h-screen flex flex-col">

<header class="print-hidden fixed top-0 left-0 w-full md:left-64 md:w-[calc(100%-16rem)] h-16 bg-blue-900 text-white flex items-center justify-between p-4 shadow-lg z-50">
    <button id="menu-toggle" class="md:hidden text-2xl"><i class="fas fa-bars"></i></button>
    <span class="font-bold text-lg sm:text-xl">
        Lançamento de Notas 
        <?php if ($is_simulating): ?>
            <span class="bg-yellow-500 text-black text-xs px-2 py-1 rounded ml-2">SIMULAÇÃO GESTOR (EDICAO)</span>
        <?php endif; ?>
    </span>
    <div class="flex items-center gap-4 ml-auto">
        <span class="hidden sm:block font-bold"><?= htmlspecialchars($nome_professor) ?></span>
    </div>
</header>

<div id="overlay" class="overlay"></div>

<nav id="sidebar" class="sidebar fixed top-0 left-0 w-64 h-full bg-blue-900 text-white p-4 pt-16 shadow-lg overflow-y-auto">
    <div class="flex flex-col items-center justify-center p-4">
        <span class="text-xl font-bold text-center"><?= htmlspecialchars($nome_professor) ?></span>
    </div>
    <ul class="mt-8 space-y-2">
        <li><a href="painel_professor1.php" class="flex items-center gap-3 p-3 rounded-lg hover:bg-blue-700"><i class="fas fa-arrow-left"></i> <span>Voltar</span></a></li>
        <li><a href="caderneta_professor.php" class="flex items-center gap-3 p-3 rounded-lg hover:bg-blue-700"><i class="fas fa-book"></i> <span>Caderneta (AVs)</span></a></li>
        <li><a href="mini_pauta_professor1.php" class="flex items-center gap-3 p-3 rounded-lg bg-blue-700"><i class="fas fa-pen"></i> <span>Mini-Pauta (MT)</span></a></li>
        
        <?php if ($is_simulating): ?>
            <li><a href="retornar_acesso.php" class="flex items-center gap-3 p-3 rounded-lg bg-red-600 hover:bg-red-700 font-bold"><i class="fas fa-undo"></i> <span>Voltar ao Perfil Gestor</span></a></li>
        <?php else: ?>
            <li><a href="login.php" class="flex items-center gap-3 p-3 rounded-lg hover:bg-blue-700"><i class="fas fa-sign-out-alt"></i> <span>Sair</span></a></li>
        <?php endif; ?>
        
    </ul>
</nav>

<main class="content flex-grow p-4 md:p-6 md:ml-64 mt-16">
    <h1 class="text-3xl font-bold text-gray-800 mb-6 print-hidden">Mini-Pauta: Lançamento de NPT</h1>

    <?php if ($mensagem_sucesso): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4 print-hidden"><?= htmlspecialchars($mensagem_sucesso) ?></div>
    <?php endif; ?>
    <?php if ($mensagem_erro): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4 print-hidden"><?= htmlspecialchars($mensagem_erro) ?></div>
    <?php endif; ?>

    <form action="" method="GET" class="form-filtros bg-white p-6 rounded-xl shadow-md mb-6 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 items-end print-hidden">
        <div>
            <label for="turma" class="block text-gray-700 font-semibold mb-2">Turma:</label>
            <select id="turma" name="turma_id" class="w-full p-3 rounded-lg border border-gray-300 focus:ring focus:ring-blue-200 transition-colors" required onchange="this.form.submit()">
                <option value="">Selecione</option>
                <?php foreach ($turmas as $turma): ?>
                    <option value="<?= $turma['id'] ?>" <?= $turma_id == $turma['id'] ? 'selected' : '' ?>><?= $turma['descricao_formatada'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="disciplina" class="block text-gray-700 font-semibold mb-2">Disciplina:</label>
            <select id="disciplina" name="disciplina_id" class="w-full p-3 rounded-lg border border-gray-300 focus:ring focus:ring-blue-200 transition-colors" required>
                <option value="">Selecione</option>
                <?php foreach ($disciplinas as $disciplina): ?>
                    <option value="<?= $disciplina['id'] ?>" <?= $disciplina_id == $disciplina['id'] ? 'selected' : '' ?>><?= $disciplina['nome'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="trimestre" class="block text-gray-700 font-semibold mb-2">Trimestre:</label>
            <select id="trimestre" name="trimestre" class="w-full p-3 rounded-lg border border-gray-300 focus:ring focus:ring-blue-200 transition-colors" required>
                <option value="">Selecione</option>
                <option value="1" <?= $trimestre_selecionado == 1 ? 'selected' : '' ?>>1º</option>
                <option value="2" <?= $trimestre_selecionado == 2 ? 'selected' : '' ?>>2º</option>
                <option value="3" <?= $trimestre_selecionado == 3 ? 'selected' : '' ?>>3º</option>
            </select>
        </div>
        <div class="col-span-1 sm:col-span-2 lg:col-span-1">
            <button type="submit" class="w-full bg-blue-900 text-white py-3 px-6 rounded-lg hover:bg-blue-800 transition"><i class="fas fa-search"></i> Filtrar</button>
        </div>
    </form>

    <?php if ($turma_id && $disciplina_id && $trimestre_selecionado): ?>
        
        <div class="print-hidden mb-4 flex justify-end gap-3">
            
            <?php if ($is_professor || $is_simulating): ?>
                <a href="mini_pauta_anual.php?turma_id=<?= htmlspecialchars($turma_id) ?>&disciplina_id=<?= htmlspecialchars($disciplina_id) ?>" 
                    target="_blank" 
                    class="bg-purple-600 text-white py-2 px-4 rounded-lg hover:bg-purple-700 transition flex items-center gap-2 text-sm font-semibold">
                    <i class="fas fa-file-alt"></i> Caderneta Anual (A4)
                </a>
            <?php endif; ?>
            
            <button onclick="window.print()" class="bg-indigo-600 text-white py-2 px-4 rounded-lg hover:bg-indigo-700 transition flex items-center gap-2 text-sm font-semibold">
                <i class="fas fa-print"></i> Imprimir Mini-Pauta Trimestral
            </button>
        </div>
        <div class="print-table-container bg-white p-6 rounded-xl shadow-md">
            
             <div class="print-header hidden">
                <div class="header-insignia">
                    <img src="insignia/insignia.png" alt="Emblema da República">
                </div>
                
                <div class="header-text">
                    <p style="font-weight: bold; font-size: 11pt;"><?= htmlspecialchars($nome_republica) ?></p>
                    <p style="font-size: 10pt;"><?= htmlspecialchars($nome_governo) ?></p>
                    <p style="font-size: 10pt;"><?= htmlspecialchars($nome_gabinete) ?></p>
                    <p style="font-weight: bold; font-size: 11pt;"><?= htmlspecialchars($nome_escola) ?></p>
                </div>

                <p class="header-title">MINI-PAUTA DO <?= htmlspecialchars($trimestre_selecionado) ?>º TRIMESTRE</p>

                <div class="header-info" style="max-width: 90%; margin: 0 auto;">
                    <p>
                        <span class="info-label">Disciplina:</span>
                        <span class="info-value"><?= htmlspecialchars($nome_disciplina) ?></span>
                    </p>
                    <p>
                        <span class="info-label">Classe:</span>
                        <span class="info-value"><?= htmlspecialchars($classe_dinamica) ?></span>
                        <span class="info-label" style="padding-left: 15px;">Área:</span>
                        <span class="info-value"><?= htmlspecialchars($curso_area_dinamica) ?></span>
                    </p>
                    <p>
                        <span class="info-label">Turma:</span>
                        <span class="info-value"><?= htmlspecialchars($nome_turma_dinamica) ?></span>
                        <span class="info-label" style="padding-left: 15px;">Sala:</span>
                        <span class="info-value"><?= htmlspecialchars($sala_dinamica) ?></span>
                        <span class="info-label" style="padding-left: 15px;">Turno:</span>
                        <span class="info-value"><?= htmlspecialchars($turno_dinamico) ?></span>
                    </p>
                    <p>
                        <span class="info-label">Professor:</span>
                        <span class="info-value"><?= htmlspecialchars($nome_professor) ?></span>
                        <span class="info-label" style="padding-left: 15px;">Ano Lectivo:</span>
                        <span class="info-value"><?= htmlspecialchars($ano_lectivo_atual) ?></span>
                    </p>
                </div>
                <hr style="border: 0; border-top: 1px solid #000; margin: 10px 0;">
            </div>
            <h2 class="text-xl font-bold text-gray-700 mb-4 print-hidden"><?= htmlspecialchars($nome_disciplina) ?> - <?= htmlspecialchars($nome_turma_selecionada) ?> (<?= $trimestre_selecionado ?>º Trimestre)</h2>
<?php
// ---------------------------------------------------------
// BLOQUEIO DE LANÇAMENTO PARA NPP E NPT
// ---------------------------------------------------------

$ano_lectivo_atual = "2025/2026";
$data_hoje = date("Y-m-d");

// Variáveis de Estado (Inicia como liberado)
$npt_bloqueado = false;
$npp_bloqueado = false;
$motivo_bloqueio_npt = "";
$motivo_bloqueio_npp = "";

// 1. VERIFICAR PRAZO DO NPT
// -------------------------
$tipo_nota = 'NPT';
$stmt_npt = $conn->prepare("
    SELECT data_inicio, data_fim
    FROM prazos_lancamento
    WHERE ano_lectivo = ? AND trimestre = ? AND tipo_nota = ?
    LIMIT 1
");
$stmt_npt->bind_param("sis", $ano_lectivo_atual, $trimestre_selecionado, $tipo_nota);
$stmt_npt->execute();
$resultado_npt = $stmt_npt->get_result()->fetch_assoc();

if ($resultado_npt) {
    $inicio = $resultado_npt['data_inicio'];
    $fim = $resultado_npt['data_fim'];

    if ($data_hoje < $inicio) {
        $npt_bloqueado = true;
        $motivo_bloqueio_npt = "O prazo para NPT só inicia em " . date("d/m/Y", strtotime($inicio));
    } elseif ($data_hoje > $fim) {
        $npt_bloqueado = true;
        $motivo_bloqueio_npt = "O prazo para NPT terminou no dia " . date("d/m/Y", strtotime($fim));
    }
} else {
    $npt_bloqueado = true;
    $motivo_bloqueio_npt = "O prazo para NPT ainda não foi definido.";
}
$stmt_npt->close();


// 2. VERIFICAR PRAZO DO NPP
// -------------------------
$tipo_nota = 'NPP';
$stmt_npp = $conn->prepare("
    SELECT data_inicio, data_fim
    FROM prazos_lancamento
    WHERE ano_lectivo = ? AND trimestre = ? AND tipo_nota = ?
    LIMIT 1
");
$stmt_npp->bind_param("sis", $ano_lectivo_atual, $trimestre_selecionado, $tipo_nota);
$stmt_npp->execute();
$resultado_npp = $stmt_npp->get_result()->fetch_assoc();

if ($resultado_npp) {
    $inicio = $resultado_npp['data_inicio'];
    $fim = $resultado_npp['data_fim'];

    if ($data_hoje < $inicio) {
        $npp_bloqueado = true;
        $motivo_bloqueio_npp = "O prazo para NPP só inicia em " . date("d/m/Y", strtotime($inicio));
    } elseif ($data_hoje > $fim) {
        $npp_bloqueado = true;
        $motivo_bloqueio_npp = "O prazo para NPP terminou no dia " . date("d/m/Y", strtotime($fim));
    }
} else {
    $npp_bloqueado = true;
    $motivo_bloqueio_npp = "O prazo para NPP ainda não foi definido.";
}
$stmt_npp->close();

// FECHAMENTO OBRIGATÓRIO DO BLOCO PHP ANTES DE INICIAR O HTML
?>

            <form method="POST">
                
                <?php if ($is_simulating): ?>
                    <p class="text-yellow-700 font-semibold mb-4 print-hidden">AVISO: O Subdirector Pedagógico está em modo de edição e pode salvar alterações.</p>
                <?php elseif ($npt_bloqueado && $npp_bloqueado && !$is_simulating): ?>
                    <p class="text-red-500 font-semibold mb-4 print-hidden">AVISO: O prazo de lançamento para este trimestre foi totalmente fechado para esta disciplina. Não é possível editar as notas.</p>
                <?php endif; ?>
                
                <input type="hidden" name="salvar_notas" value="1">
                <input type="hidden" name="turma_id" value="<?= $turma_id ?>">
                <input type="hidden" name="disciplina_id" value="<?= $disciplina_id ?>">
                <input type="hidden" name="trimestre" value="<?= $trimestre_selecionado ?>">

                <div class="overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead class="bg-blue-900 text-white">
                            <tr>
                                <th rowspan="2" class="coluna-nome-aluno-header">Nº</th>
                                <th rowspan="2" class="coluna-nome-aluno-header coluna-nome-aluno-tela">Nome Completo do Aluno</th>
                                <th colspan="3">Trimestre <?= htmlspecialchars($trimestre_selecionado) ?></th>
                                <?php if ($trimestre_selecionado == 3): ?>
                                <th colspan="6">Notas Finais</th> <?php endif; ?>
                                <th rowspan="2">OBS.</th>
                            </tr>
                            <tr>
                                <th>MAC</th>
                                <th>NPT</th>
                                <th>MT</th>
                                <?php if ($trimestre_selecionado == 3): ?>
                                <th>MFD</th>
                                <th>NEO</th>
                                <th>NEE</th>
                                <th>MEC</th>
                                <th>MF</th>
                                <th>ESTADO</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $contador = 1; ?>
                            <?php 
                            // Função auxiliar para determinar a classe de cor da nota
                            $determina_classe = function($nota) {
                                if ($nota === null || (string)$nota === '') return ''; 
                                $nota_float = (float)str_replace(',', '.', $nota); // Garante que aceita formato com vírgula para cálculo
                                return ($nota_float >= 10.0) ? 'nota-aprovada' : 'nota-reprovada';
                            };

                            // Função para checar se a nota é nula, zero ou vazia (no contexto do PHP)
                            $is_nota_vazia = function($nota) {
                                // Se for null ou uma string vazia ("" ou "0.00")
                                return $nota === null || (string)$nota === '' || (float)$nota === 0.0;
                            };
                            ?>


                            <?php foreach ($alunos as $aluno): 

                                $aluno_id = $aluno['id'];

                                // -----------------------------------------------------
                                // Notas do Trimestre Selecionado
                                // -----------------------------------------------------
                                $nota_atual = $notas_por_aluno[$aluno_id][$trimestre_selecionado] ?? [];
                                $mac_salvo = $nota_atual['mac'] ?? null;
                                $npt_salvo = $nota_atual['npt'] ?? null;
                                $mt_salvo = $nota_atual['mt'] ?? null;

                                $mac_classe = $determina_classe($mac_salvo);
                                $npt_classe = $determina_classe($npt_salvo);
                                $mt_classe = $determina_classe($mt_salvo);

                                // -----------------------------------------------------
                                // CÁLCULOS FINAIS (Apenas se 3º Trimestre)
                                // -----------------------------------------------------
                                $mfd = $neo_salvo = $nee_salvo = $mec = $mf = null;
                                $estado_final = '---';
                                $mf_display = '---';
                                $estado_classe = 'estado-final-incompleto';

                                if ($trimestre_selecionado == 3) {
                                    $mts_calc = [];
                                    for ($i = 1; $i <= 3; $i++) {
                                        $mt_nota = $notas_por_aluno[$aluno_id][$i]['mt'] ?? null;
                                        $mts_calc[$i] = $mt_nota !== null ? (float)$mt_nota : null;
                                    }

                                    $nota_t1 = $mts_calc[1];
                                    $nota_t2 = $mts_calc[2];
                                    $nota_t3 = $mts_calc[3];

                                    $neo_salvo = $notas_por_aluno[$aluno_id][3]['neo'] ?? null;
                                    $nee_salvo = $notas_por_aluno[$aluno_id][3]['nee'] ?? null;

                                    if ($nota_t1 !== null && $nota_t2 !== null && $nota_t3 !== null) {
                                        $mfd = round(($nota_t1 + $nota_t2 + $nota_t3) / 3.0, 2);
                                    }
                                    $mfd_float = $mfd !== null ? (float)$mfd : null;

                                    $neo_float = $neo_salvo !== null ? (float)$neo_salvo : null;
                                    $nee_float = $nee_salvo !== null ? (float)$nee_salvo : null;

                                    if ($neo_float !== null && $nee_float !== null) {
                                        $mec = round(($neo_float + $nee_float) / 2.0, 2);
                                    }
                                    $mec_valor = $mec ?? 0.0;
                                    $neo_valor = $neo_float ?? 0.0;
                                    $nee_valor = $nee_float ?? 0.0;

                                    if ($mfd_float !== null) {
                                        $mf_final = null;

                                        if ($neo_valor > 0.00 && $nee_valor > 0.00) {
                                            $mf_calculada = ($mfd_float * 0.6) + ($mec_valor * 0.4);
                                            $mf_final = round($mf_calculada, 2);
                                        } elseif ($nee_valor > 0.00) {
                                            $mf_calculada = ($mfd_float * 0.6) + ($nee_valor * 0.4);
                                            $mf_final = round($mf_calculada, 2);
                                        } else {
                                            $mf_final = round($mfd_float);
                                        }

                                        if ($mf_final >= 9.5) {
                                            $mf_aprovacao = round($mf_final);
                                        } else {
                                            $mf_aprovacao = $mf_final;
                                        }
                                        $mf = (string)$mf_aprovacao;
                                    }

                                    // Estado Final
                                    $estado_final = 'INCOMPLETO';
                                    $estado_classe = 'estado-final-incompleto';
                                    if ($mf !== null) {
                                        $mf_float_final = (float)$mf;
                                        if ($mf_float_final >= 10.0) {
                                            $estado_final = 'APROVADO';
                                            $estado_classe = 'estado-final-aprovado';
                                            $mf_display = number_format(round($mf_float_final), 0, ',', '.');
                                        } else {
                                            $estado_final = 'REPROVADO';
                                            $estado_classe = 'estado-final-reprovado';
                                            $mf_display = number_format($mf_float_final, 2, ',', '.');
                                        }
                                    }
                                }

                                // Classes condicionais
                                $mfd_classe = $determina_classe($mfd);
                                $neo_classe = $determina_classe($neo_salvo);
                                $nee_classe = $determina_classe($nee_salvo);
                                $mec_classe = $determina_classe($mec);
                                $mf_classe = $determina_classe($mf);
                            ?>

                            <tr>
                                <td><?= $contador++ ?></td>
                                <td class="coluna-nome-aluno coluna-nome-aluno-tela text-left">
                                    <?= htmlspecialchars($aluno['nome']) ?>
                                    <input type="hidden" name="aluno_id[]" value="<?= $aluno_id ?>">
                                </td>

                                <td class="mac-input <?= $mac_classe ?>" id="mac_<?= $aluno_id ?>" data-nota-valor="<?= number_format($mac_salvo, 2, ',', '.') ?>">
                                    <?= $mac_salvo !== null ? number_format($mac_salvo, 2, ',', '.') : '---' ?>
                                </td>

                            <td class="<?= $npt_classe ?> print-value" data-nota-valor="<?= $npt_salvo !== null ? number_format($npt_salvo, 2, ',', '.') : '---' ?>">
                                <?php if (!$npt_bloqueado || $is_simulating): ?>
                                    <input type="text" name="npt_<?= $trimestre_selecionado ?>_<?= $aluno_id ?>" 
                                        value="<?= $npt_salvo !== null ? number_format($npt_salvo, 2, ',', '.') : '' ?>" 
                                        class="nota-input text-center <?= $npt_classe ?>" 
                                        data-aluno-id="<?= $aluno_id ?>" data-trimestre="<?= $trimestre_selecionado ?>" data-nota-tipo="npt" 
                                        oninput="calculaMT(this.value, '<?= $mac_salvo ?>', 'mt_<?= $aluno_id ?>')"
                                        onkeypress="return onlyNumbersAndComma(event)" maxlength="5"
                                        placeholder="0.00">
                                <?php else: ?>
                                    <span title="<?= htmlspecialchars($motivo_bloqueio_npt) ?>">
                                        <?= $npt_salvo !== null ? number_format($npt_salvo, 2, ',', '.') : '---' ?>
                                    </span>
                                <?php endif; ?>
                            </td>

                            <td id="mt_<?= $aluno_id ?>" class="nota-calculada <?= $mt_classe ?>" data-nota-valor="<?= number_format($mt_salvo, 2, ',', '.') ?>">
                                <?= $mt_salvo !== null ? number_format($mt_salvo, 2, ',', '.') : '---' ?>
                            </td>
                            
                            <?php if ($trimestre_selecionado == 3): ?>
                                <td id="mfd_<?= $aluno_id ?>" class="nota-calculada <?= $mfd_classe ?>" data-nota-valor="<?= $mfd !== null ? number_format($mfd, 2, ',', '.') : '---' ?>">
                                    <?= $mfd !== null ? number_format($mfd, 2, ',', '.') : '---' ?>
                                </td>

                                <td>
                                    <?php if (!$npp_bloqueado || $is_simulating): ?>
                                        <input type="text" name="neo_3_<?= $aluno_id ?>"
                                            value="<?= $neo_salvo !== null ? number_format($neo_salvo, 2, ',', '.') : '' ?>"
                                            class="nota-input text-center <?= $neo_classe ?>"
                                            data-aluno-id="<?= $aluno_id ?>" data-nota-tipo="neo"
                                            oninput="calculaMFD(this.value, '<?= $nee_salvo ?>', '<?= $mfd_float ?>', 'mf_<?= $aluno_id ?>')"
                                            onkeypress="return onlyNumbersAndComma(event)" maxlength="5"
                                            placeholder="0.00">
                                    <?php else: ?>
                                        <span title="<?= htmlspecialchars($motivo_bloqueio_npp) ?>">
                                            <?= $neo_salvo !== null ? number_format($neo_salvo, 2, ',', '.') : '---' ?>
                                        </span>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <?php if (!$npp_bloqueado || $is_simulating): ?>
                                        <input type="text" name="nee_3_<?= $aluno_id ?>"
                                            value="<?= $nee_salvo !== null ? number_format($nee_salvo, 2, ',', '.') : '' ?>"
                                            class="nota-input text-center <?= $nee_classe ?>"
                                            data-aluno-id="<?= $aluno_id ?>" data-nota-tipo="nee"
                                            oninput="calculaMFD('<?= $neo_salvo ?>', this.value, '<?= $mfd_float ?>', 'mf_<?= $aluno_id ?>')"
                                            onkeypress="return onlyNumbersAndComma(event)" maxlength="5"
                                            placeholder="0.00">
                                    <?php else: ?>
                                        <span title="<?= htmlspecialchars($motivo_bloqueio_npp) ?>">
                                            <?= $nee_salvo !== null ? number_format($nee_salvo, 2, ',', '.') : '---' ?>
                                        </span>
                                    <?php endif; ?>
                                </td>

                                <td id="mec_<?= $aluno_id ?>" class="nota-calculada <?= $mec_classe ?>" data-nota-valor="<?= number_format($mec, 2, ',', '.') ?>">
                                    <?= $mec !== null ? number_format($mec, 2, ',', '.') : '---' ?>
                                </td>

                                <td id="mf_<?= $aluno_id ?>" class="nota-final <?= $mf_classe ?>" data-nota-valor="<?= number_format($mf, 2, ',', '.') ?>">
                                    <?= $mf_display ?>
                                </td>

                                <td class="<?= $estado_classe ?>">
                                    <?= $estado_final ?>
                                </td>

                            <?php endif; ?>

                            <td>
                                </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-6 flex justify-end print-hidden">
                <button type="submit" class="bg-green-600 text-white py-3 px-6 rounded-lg hover:bg-green-700 transition">
                    <i class="fas fa-save"></i> Salvar Notas
                </button>
            </div>
        </form>
            <div class="print-footer hidden">
                <div class="data-catumbela">
                    <?= htmlspecialchars($localidade) ?>, aos <span><?= date('d') ?></span> de <span><?= date('F') ?></span> de <span><?= date('Y') ?></span>
                </div>
                <div class="footer-grid mt-6">
                    <div>
                        <div class="assinatura-linha"></div>
                        <p class="nome-assinado"><?= htmlspecialchars($nome_professor) ?></p>
                        <p>O Professor(a)</p>
                    </div>
                    <div>
                        <div class="assinatura-linha"></div>
                        <p class="nome-assinado"><?= htmlspecialchars($nome_sub_diretor) ?></p>
                        <p>O Subdirector Pedagógico</p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</main>

<?php
// Inicia a sessão
session_start();

// Garanta que este arquivo existe e a conexão funciona.
// A linha 'session_start()' DEVERIA ser removida daqui se você a adicionou no conexao.php.
include 'conexao.php'; 

// =================================================================================
// 1. LÓGICA DE CONTROLE DE SESSÃO
// =================================================================================
$usuario_id = (int)($_SESSION['usuario']['id'] ?? $_SESSION['usuario']['id_funcionario'] ?? 0);

$perfil = $_SESSION['usuario']['perfil'] ?? '';

$is_professor = strtoupper(trim($perfil)) === 'PROFESSOR';
$is_simulating = $_SESSION['simulando'] ?? false; // Flag para saber se é o gestor

$id_para_consulta = $usuario_id; 

if (!$is_professor && !$is_simulating) {
    header('Location: login.php');
    exit;
}
if ($usuario_id <= 0) { 
    header('Location: login.php');
    exit;
}

// ... Busca do Nome do Professor ...
$nome_professor = '';
$sqlNome = "SELECT nome FROM usuarios WHERE id = ? LIMIT 1";
$stmt = $conn->prepare($sqlNome);
if ($stmt) {
    $stmt->bind_param("i", $usuario_id);
    $stmt->execute();
    $resNome = $stmt->get_result();
    if ($resNome && $resNome->num_rows === 1) {
        $rowNome = $resNome->fetch_assoc();
        $nome_professor = $rowNome['nome'];
    }
    $stmt->close();
}

// Ano lectivo e Variáveis Estáticas
$ano_lectivo_atual = '2025/2026';
$nome_republica = "REPÚBLICA DE ANGOLA";
$nome_governo = "GOVERNO PROVINCIAL DE BENGUELA";
$nome_gabinete = "GABINETE PROVINCIAL DA EDUCAÇÃO";
$nome_escola = "COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA";
$nome_sub_diretor = "Anacleto Domingos de Oliveira Cachiuenjo";
$localidade = "CATUMBELA";

// Variáveis dinâmicas da turma (inicializadas)
$classe_dinamica = '';
$nome_turma_dinamica = '';
$curso_area_dinamica = '';
$turno_dinamico = '';
$sala_dinamica = '';
$turma_completa = '';

// =================================================================================
// 2. INCLUSÃO DA LÓGICA DE SALVAR NOTAS (REMOVIDA DA VISUALIZAÇÃO)
// =================================================================================
// NOTA: Esta lógica deve estar em 'salvar_notas.php' para ser acessada via POST.
// O action do formulário foi ajustado abaixo para apontar para o arquivo correto.

// =================================================================================
// 3. FILTROS E BUSCA DE DADOS
// ... (O restante da lógica de busca de Turmas, Disciplinas e Alunos permanece inalterado) ...

$turma_id = $_GET['turma_id'] ?? null;
$disciplina_id = $_GET['disciplina_id'] ?? null;
$trimestre_selecionado = $_GET['trimestre'] ?? null;
$nome_disciplina = '';
$nome_turma_selecionada = '';
$prazo_fechado = false;

// Busca de Turmas
$turmas = [];
$sqlTurmas = "
    SELECT DISTINCT t.id, t.nome, t.classe, t.sala, t.curso, t.turno
    FROM turmas t
    INNER JOIN atribuicoes a ON t.id = a.turma_id
    WHERE a.professor_id = ?
    ORDER BY t.classe, t.nome
";
$stmt = $conn->prepare($sqlTurmas);
$stmt->bind_param("i", $id_para_consulta); 
$stmt->execute();
$turmas_res = $stmt->get_result();
$turmas = [];
while ($row = $turmas_res->fetch_assoc()) {
    $partes = [];
    if ($row['classe']) $partes[] = $row['classe'];
    if ($row['nome']) $partes[] = $row['nome'];
    if ($row['curso']) $partes[] = $row['curso'];
    if ($row['turno']) $partes[] = $row['turno'];
    if ($row['sala']) $partes[] = $row['sala'];
    $row['descricao_formatada'] = implode('-', $partes); 
    $turmas[] = $row;
}
$stmt->close();

// Busca de Disciplinas
$disciplinas = [];
if ($turma_id) {
    $sqlDisciplinas = "
        SELECT DISTINCT d.id, d.nome
        FROM atribuicoes a
        INNER JOIN disciplinas d ON a.turma_id = a.turma_id AND a.disciplina_id = d.id
        WHERE a.professor_id = ? AND a.turma_id = ?
        ORDER BY d.nome
    ";
    $stmt = $conn->prepare($sqlDisciplinas);
    $stmt->bind_param("ii", $id_para_consulta, $turma_id);
    $stmt->execute();
    $disciplinas_res = $stmt->get_result();
    while ($disciplina = $disciplinas_res->fetch_assoc()) {
        $disciplinas[] = $disciplina;
    }
    $stmt->close();
}

// Busca do nome da disciplina
if ($disciplina_id) {
    $sqlNomeDisciplina = "SELECT nome FROM disciplinas WHERE id = ?";
    $stmt = $conn->prepare($sqlNomeDisciplina);
    $stmt->bind_param("i", $disciplina_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows > 0) {
        $row = $res->fetch_assoc();
        $nome_disciplina = $row['nome'];
    }
    $stmt->close();
}

// Detalhes da Turma para o Cabeçalho
if ($turma_id) {
    foreach ($turmas as $turma) {
        if ($turma['id'] == $turma_id) {
            $nome_turma_selecionada = $turma['descricao_formatada'];
            
            $partes_turma = explode('-', $nome_turma_selecionada);
            $classe_dinamica = $partes_turma[0] ?? ''; 
            $nome_turma_dinamica = $partes_turma[1] ?? ''; 
            $curso_area_dinamica = $partes_turma[2] ?? ''; 
            $turno_dinamico = $partes_turma[3] ?? ''; 
            $sala_dinamica = $partes_turma[4] ?? ''; 

            $turma_completa = "Turma: " . $nome_turma_dinamica . " - " . $turno_dinamico . " sala nº " . $sala_dinamica;
            
            break;
        }
    }
}

$alunos = [];
$notas_por_aluno = [];
if ($turma_id && $disciplina_id && $trimestre_selecionado) {
    // Verifica se o trimestre já foi fechado 
    $sqlCheckFecho = "SELECT COUNT(*) 
        FROM fecho_trimestre 
        WHERE turma_id = ? AND disciplina_id = ? AND trimestre = ?";
    $stmtCheckFecho = $conn->prepare($sqlCheckFecho);
    $stmtCheckFecho->bind_param("iii", $turma_id, $disciplina_id, $trimestre_selecionado);
    $stmtCheckFecho->execute();
    $count = $stmtCheckFecho->get_result()->fetch_row()[0];
    $stmtCheckFecho->close();
    $prazo_fechado = ($count > 0);

    // Buscar alunos da turma
    $sqlAlunos = "SELECT id, nome FROM alunos WHERE turma_id = ? ORDER BY nome";
    $stmtAlunos = $conn->prepare($sqlAlunos);
    $stmtAlunos->bind_param("i", $turma_id);
    $stmtAlunos->execute();
    $alunos_res = $stmtAlunos->get_result();
    $alunos_data = $alunos_res->fetch_all(MYSQLI_ASSOC);
    $stmtAlunos->close();

    // Buscar notas já lançadas
    $aluno_ids = array_column($alunos_data, 'id');
    if (!empty($aluno_ids)) {
        $in_clause = str_repeat('?,', count($aluno_ids) - 1) . '?';
        // Buscamos todas as notas para que o JavaScript possa calcular o MFD e MF
        $sqlNotas = "SELECT * FROM notas 
            WHERE aluno_id IN ($in_clause) AND disciplina_id = ? AND turma_id = ?";
        $params_types = str_repeat('i', count($aluno_ids)) . 'ii';
        $params = array_merge($aluno_ids, [$disciplina_id, $turma_id]);

        $stmtNotas = $conn->prepare($sqlNotas);
        // O array_merge precisa ser desempacotado com '...'
        $stmtNotas->bind_param($params_types, ...$params); 
        $stmtNotas->execute();
        $resultNotas = $stmtNotas->get_result();
        while ($nota = $resultNotas->fetch_assoc()) {
            $notas_por_aluno[$nota['aluno_id']][$nota['trimestre']] = $nota;
        }
        $stmtNotas->close();
    }

    $alunos = $alunos_data;
}

// Mensagens de feedback
$mensagem_sucesso = $_SESSION['mensagem_sucesso'] ?? '';
$mensagem_erro = $_SESSION['mensagem_erro'] ?? '';
unset($_SESSION['mensagem_sucesso'], $_SESSION['mensagem_erro']);

// Variáveis injetadas no JavaScript
$notas_js = json_encode($notas_por_aluno);
$trimestre_js = (int)($trimestre_selecionado ?? 0);

// =================================================================================
// BLOQUEIO DE LANÇAMENTO PARA NPP E NPT (Mantido no PHP para controle do FORM)
// =================================================================================
$ano_lectivo_atual_p = "2025/2026";
$data_hoje = date("Y-m-d");

// Variáveis de Estado (Inicia como liberado)
$npt_bloqueado = false;
$npp_bloqueado = false;
$motivo_bloqueio_npt = "";
$motivo_bloqueio_npp = "";

// 1. VERIFICAR PRAZO DO NPT
// -------------------------
$tipo_nota = 'NPT';
$stmt_npt = $conn->prepare("
    SELECT data_inicio, data_fim
    FROM prazos_lancamento
    WHERE ano_lectivo = ? AND trimestre = ? AND tipo_nota = ?
    LIMIT 1
");
$stmt_npt->bind_param("sis", $ano_lectivo_atual_p, $trimestre_selecionado, $tipo_nota);
$stmt_npt->execute();
$resultado_npt = $stmt_npt->get_result()->fetch_assoc();

if ($resultado_npt) {
    $inicio = $resultado_npt['data_inicio'];
    $fim = $resultado_npt['data_fim'];

    if ($data_hoje < $inicio) {
        $npt_bloqueado = true;
        $motivo_bloqueio_npt = "O prazo para NPT só inicia em " . date("d/m/Y", strtotime($inicio));
    } elseif ($data_hoje > $fim) {
        $npt_bloqueado = true;
        $motivo_bloqueio_npt = "O prazo para NPT terminou no dia " . date("d/m/Y", strtotime($fim));
    }
} else {
    $npt_bloqueado = true;
    $motivo_bloqueio_npt = "O prazo para NPT ainda não foi definido.";
}
$stmt_npt->close();


// 2. VERIFICAR PRAZO DO NPP
// -------------------------
$tipo_nota = 'NPP';
$stmt_npp = $conn->prepare("
    SELECT data_inicio, data_fim
    FROM prazos_lancamento
    WHERE ano_lectivo = ? AND trimestre = ? AND tipo_nota = ?
    LIMIT 1
");
$stmt_npp->bind_param("sis", $ano_lectivo_atual_p, $trimestre_selecionado, $tipo_nota);
$stmt_npp->execute();
$resultado_npp = $stmt_npp->get_result()->fetch_assoc();

if ($resultado_npp) {
    $inicio = $resultado_npp['data_inicio'];
    $fim = $resultado_npp['data_fim'];

    if ($data_hoje < $inicio) {
        $npp_bloqueado = true;
        $motivo_bloqueio_npp = "O prazo para NPP só inicia em " . date("d/m/Y", strtotime($inicio));
    } elseif ($data_hoje > $fim) {
        $npp_bloqueado = true;
        $motivo_bloqueio_npp = "O prazo para NPP terminou no dia " . date("d/m/Y", strtotime($fim));
    }
} else {
    $npp_bloqueado = true;
    $motivo_bloqueio_npp = "O prazo para NPP ainda não foi definido.";
}
$stmt_npp->close();

?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lançar Notas - Mini Pauta</title>
    
    <link rel="stylesheet" href="css/all.min.css">
    <link rel="stylesheet" href="css/inter.css">
    <script src="js/tailwindcss.js"></script>
    <script src="js/chart.umd.min.js"></script>
    <style>
/* Estilos de interface (desktop/mobile) - Início */

.sidebar { transition: transform 0.3s; transform: translateX(-100%); z-index: 999; }
.sidebar.active { transform: translateX(0); }
.overlay { position: fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:998; display:none; }
.overlay.active { display:block; }

@media (min-width: 768px) {
    .sidebar { transform: translateX(0); }
    .content { margin-left: 16rem; }
    .overlay { display: none !important; }
}

input[type="number"]::-webkit-outer-spin-button,
input[type="number"]::-webkit-inner-spin-button { -webkit-appearance: none; margin: 0; }
input[type="number"] { -moz-appearance: textfield; }

/* Largura padrão dos inputs de nota na tela */
.nota-input {
    width: 50px; /* Mobile */
    font-size: 0.8rem;
    border-radius: 4px; 
    background-color: white; 
}
.mac-input {
     background-color: #f3f4f6; 
     font-weight: bold;
}

@media (min-width: 768px) {
    .nota-input {
        width: 80px; /* Desktop */
        font-size: 1rem;
    }
    /* Removida a regra de min-width para notas na tela */
}

/* Melhoria de Design para a Tabela (Desktop/Mobile) */
.print-table-container table {
    border-collapse: separate; 
    border-spacing: 0;
}
.print-table-container th, .print-table-container td {
    padding: 8px 10px;
    border-bottom: 1px solid #e5e7eb; 
    border-right: 1px solid #e5e7eb;
    text-align: center;
}
.print-table-container th:first-child, .print-table-container td:first-child {
    border-left: 1px solid #e5e7eb;
}
.print-table-container tr:last-child td {
    border-bottom: 1px solid #e5e7eb;
}
.print-table-container thead {
    background-color: #1e3a8a; 
    color: white;
}
.print-table-container tbody tr:hover {
    background-color: #f9f9f9;
}

/* CORREÇÕES ESPECÍFICAS PARA NOME DO ALUNO (TELA) */
.coluna-nome-aluno-tela {
    min-width: 180px; 
    text-align: left !important;
    /* Certificar que estas regras NÃO estejam ativas na tela se estiverem causando reticências: */
    /* white-space: nowrap; 
    overflow: hidden; 
    text-overflow: ellipsis; */
}

/* Células de Notas Calculadas (Estilo Padrão, será sobrescrito se tiver valor) */
.nota-calculada { background-color: #e0f2f1; font-weight: bold; color: #0f766e; } /* MT, MFD, MEC */
.nota-final-calc { background-color: #fef2f2; font-weight: bold; color: #b91c1c; } /* MF */

/* === ESTILOS DE NOTAS FINAIS === */
.nota-aprovada {
    background-color: #d1fae5 !important; /* Verde muito claro */
    color: #065f46 !important; /* Verde escuro */
    font-weight: bold;
}
.nota-reprovada {
    background-color: #fecaca !important; /* Vermelho muito claro */
    color: #991b1b !important; /* Vermelho escuro */
    font-weight: bold;
}

.estado-final-aprovado { background-color: #d1fae5; color: #065f46; font-weight: bold; }
.estado-final-reprovado { background-color: #fecaca; color: #991b1b; font-weight: bold; }
.estado-final-incompleto { background-color: #fef3c7; color: #b45309; font-weight: bold; }

/* Estilos de interface (desktop/mobile) - Fim */
/* ------------------------------------------- */


/* ================================================= */
/* ESTILOS DE IMPRESSÃO (A4) - OTIMIZAÇÃO MAXIMIZADA */
/* ================================================= */
@media print {
    @page {
        size: A4 portrait; 
        margin: 5mm; 
    }

    .print-hidden, .sidebar, header, nav, .overlay, .form-filtros, .btn-salvar-notas {
        display: none !important;
    }
    
    body, main, .content {
        margin: 0 !important;
        padding: 0 !important;
        min-height: initial !important;
        background-color: white !important;
    }

    .print-table-container {
        box-shadow: none !important;
        border: none !important;
    }
    table {
        width: 100% !important;
        border-collapse: collapse !important;
        font-size: 8pt; 
        table-layout: fixed; /* Essencial para que as larguras fixas funcionem */
    }
    th, td {
        border: 1px solid #000 !important;
        padding: 1px 3px !important; 
        color: #000 !important; 
        background-color: white !important; /* Branco na impressão */
        height: 15px; 
    }
    thead {
        -webkit-print-color-adjust: exact;
        color-adjust: exact;
        background-color: #d1d5db !important; 
        color: #000 !important;
    }
    
    /* Remove a cor da célula na impressão e mostra apenas o texto */
    .nota-aprovada, .nota-reprovada, .nota-calculada, .nota-final-calc {
        background-color: white !important;
        color: #000 !important;
    }

    /* --- AJUSTES DE LARGURA DAS COLUNAS (MAXIMIZAÇÃO DO NOME) --- */

    /* 1. COLUNA N.º DE ORDEM (Assumindo a 1ª coluna) */
    td:nth-child(1), th:nth-child(1) {
        width: 3% !important; 
        text-align: center !important;
    }

    /* 2. COLUNA DO NOME DO ALUNO (2ª COLUNA) - MAXIMIZADA E CORRIGIDA */
    .coluna-nome-aluno {
        width: 60% !important; /* MAXIMIZADO para 60% */
        min-width: 150px;
        text-align: left !important;
        padding-left: 5px !important;
        
        /* CORREÇÃO: Força linha única e elimina as reticências */
        white-space: nowrap; /* Garante que o nome fique em uma única linha */
        overflow: hidden; /* Oculta o que excede a largura (sem reticências) */
        text-overflow: clip; /* Garante que o corte não seja com reticências */
    }
    .coluna-nome-aluno-header {
        text-align: left !important;
        padding-left: 5px !important;
    } 

    /* Ocultar inputs e colunas de exame/mfd na impressão (Manter apenas o valor) */
    .nota-input { display: none !important; }

    /* CORREÇÃO/REFORÇO: Mostra o valor de nota a partir do data-nota-valor na impressão */
    .print-value::before { 
        content: attr(data-nota-valor); 
        display: block; 
        text-align: center; /* Centraliza o valor que aparece na impressão */
    }
    
    /* 3. COLUNAS DE NOTAS TRIMESTRAIS (MAC, NPT, MT - 3ª, 4ª, 5ª) - REDUZIDAS */
    td:nth-child(3), td:nth-child(4), td:nth-child(5) {
        width: 3% !important; /* REDUZIDO para 3% (Total 9%) */
    }
    
    /* 4. Colunas finais (MFD/NEO/NEE/MEC/MF/ESTADO - 6ª a 11ª) - REDUZIDAS */
    td:nth-child(6), td:nth-child(7), td:nth-child(8), td:nth-child(9), td:nth-child(10), td:nth-child(11) {
        width: 4% !important; /* REDUZIDO para 4% (Total 24%) */
    }
    
    /* 5. Coluna OBS. (12ª coluna) */
    td:nth-child(12), th:nth-child(12) {
        width: 4% !important; /* 4% restante */
    }
    
    /* --- CABEÇALHO --- */
    .print-header {
        display: block !important;
        text-align: center;
        margin-bottom: 5px;
    }
    .header-insignia img { width: 40px; height: auto; margin: 0 auto; display: block; }
    .header-text { line-height: 1.1; font-size: 8pt; margin-bottom: 3px; }
    .header-text p { margin: 1px 0; }
    .header-title { font-weight: bold; margin: 3px 0 3px 0; font-size: 9pt; }
    .header-info { text-align: left; font-size: 8pt; width: 100%; margin-top: 3px; display: table; }
    .header-info p { margin: 1px 0; display: table-row; }
    .header-info .info-label { font-weight: normal; white-space: nowrap; display: table-cell; padding-right: 5px; }
    .header-info .info-value { font-weight: bold; display: table-cell; }
    hr { margin: 5px 0 !important;}

    /* --- RODAPÉ DE ASSINATURAS --- */
    .print-footer {
        display: block !important;
        margin-top: 10px;
        width: 100%;
        font-size: 8pt;
    }
    .footer-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px; 
        width: 90%; 
        margin: 0 auto;
        text-align: center;
    }
    .assinatura-linha {
        margin-top: 20px;
        border-bottom: 1px solid #000;
        width: 100%;
        height: 1px;
    }
    .nome-assinado {
        margin-top: 2px;
        font-weight: bold;
    }
    .data-catumbela {
        margin-top: 5px;
        font-size: 8pt;
    }
    .data-catumbela span {
        border-bottom: 1px solid #000;
        padding: 0 5px; 
    }
}
</style>
</head>
<body class="bg-gray-100 min-h-screen flex flex-col">

<header class="print-hidden fixed top-0 left-0 w-full md:left-64 md:w-[calc(100%-16rem)] h-16 bg-blue-900 text-white flex items-center justify-between p-4 shadow-lg z-50">
    <button id="menu-toggle" class="md:hidden text-2xl"><i class="fas fa-bars"></i></button>
    <span class="font-bold text-lg sm:text-xl">
        Lançamento de Notas 
        <?php if ($is_simulating): ?>
            <span class="bg-yellow-500 text-black text-xs px-2 py-1 rounded ml-2">SIMULAÇÃO GESTOR (EDICAO)</span>
        <?php endif; ?>
    </span>
    <div class="flex items-center gap-4 ml-auto">
        <span class="hidden sm:block font-bold"><?= htmlspecialchars($nome_professor) ?></span>
    </div>
</header>

<div id="overlay" class="overlay"></div>

<nav id="sidebar" class="sidebar fixed top-0 left-0 w-64 h-full bg-blue-900 text-white p-4 pt-16 shadow-lg overflow-y-auto">
    <div class="flex flex-col items-center justify-center p-4">
        <span class="text-xl font-bold text-center"><?= htmlspecialchars($nome_professor) ?></span>
    </div>
    <ul class="mt-8 space-y-2">
        <li><a href="painel_professor1.php" class="flex items-center gap-3 p-3 rounded-lg hover:bg-blue-700"><i class="fas fa-arrow-left"></i> <span>Voltar</span></a></li>
        <li><a href="caderneta_professor.php" class="flex items-center gap-3 p-3 rounded-lg hover:bg-blue-700"><i class="fas fa-book"></i> <span>Caderneta (AVs)</span></a></li>
        <li><a href="mini_pauta_professor1.php" class="flex items-center gap-3 p-3 rounded-lg bg-blue-700"><i class="fas fa-pen"></i> <span>Mini-Pauta (MT)</span></a></li>
        
        <?php if ($is_simulating): ?>
            <li><a href="retornar_acesso.php" class="flex items-center gap-3 p-3 rounded-lg bg-red-600 hover:bg-red-700 font-bold"><i class="fas fa-undo"></i> <span>Voltar ao Perfil Gestor</span></a></li>
        <?php else: ?>
            <li><a href="login.php" class="flex items-center gap-3 p-3 rounded-lg hover:bg-blue-700"><i class="fas fa-sign-out-alt"></i> <span>Sair</span></a></li>
        <?php endif; ?>
        
    </ul>
</nav>

<main class="content flex-grow p-4 md:p-6 md:ml-64 mt-16">
    <h1 class="text-3xl font-bold text-gray-800 mb-6 print-hidden">Mini-Pauta: Lançamento de NPT</h1>

    <?php if ($mensagem_sucesso): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4 print-hidden"><?= htmlspecialchars($mensagem_sucesso) ?></div>
    <?php endif; ?>
    <?php if ($mensagem_erro): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4 print-hidden"><?= htmlspecialchars($mensagem_erro) ?></div>
    <?php endif; ?>

    <form action="" method="GET" class="form-filtros bg-white p-6 rounded-xl shadow-md mb-6 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 items-end print-hidden">
        <div>
            <label for="turma" class="block text-gray-700 font-semibold mb-2">Turma:</label>
            <select id="turma" name="turma_id" class="w-full p-3 rounded-lg border border-gray-300 focus:ring focus:ring-blue-200 transition-colors" required onchange="this.form.submit()">
                <option value="">Selecione</option>
                <?php foreach ($turmas as $turma): ?>
                    <option value="<?= $turma['id'] ?>" <?= $turma_id == $turma['id'] ? 'selected' : '' ?>><?= $turma['descricao_formatada'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="disciplina" class="block text-gray-700 font-semibold mb-2">Disciplina:</label>
            <select id="disciplina" name="disciplina_id" class="w-full p-3 rounded-lg border border-gray-300 focus:ring focus:ring-blue-200 transition-colors" required>
                <option value="">Selecione</option>
                <?php foreach ($disciplinas as $disciplina): ?>
                    <option value="<?= $disciplina['id'] ?>" <?= $disciplina_id == $disciplina['id'] ? 'selected' : '' ?>><?= $disciplina['nome'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="trimestre" class="block text-gray-700 font-semibold mb-2">Trimestre:</label>
            <select id="trimestre" name="trimestre" class="w-full p-3 rounded-lg border border-gray-300 focus:ring focus:ring-blue-200 transition-colors" required>
                <option value="">Selecione</option>
                <option value="1" <?= $trimestre_selecionado == 1 ? 'selected' : '' ?>>1º</option>
                <option value="2" <?= $trimestre_selecionado == 2 ? 'selected' : '' ?>>2º</option>
                <option value="3" <?= $trimestre_selecionado == 3 ? 'selected' : '' ?>>3º</option>
            </select>
        </div>
        <div class="col-span-1 sm:col-span-2 lg:col-span-1">
            <button type="submit" class="w-full bg-blue-900 text-white py-3 px-6 rounded-lg hover:bg-blue-800 transition"><i class="fas fa-search"></i> Filtrar</button>
        </div>
    </form>

    <?php if ($turma_id && $disciplina_id && $trimestre_selecionado): ?>
        
        <div class="print-hidden mb-4 flex justify-end gap-3">
            
            <?php if ($is_professor || $is_simulating): ?>
                <a href="mini_pauta_anual.php?turma_id=<?= htmlspecialchars($turma_id) ?>&disciplina_id=<?= htmlspecialchars($disciplina_id) ?>" 
                    target="_blank" 
                    class="bg-purple-600 text-white py-2 px-4 rounded-lg hover:bg-purple-700 transition flex items-center gap-2 text-sm font-semibold">
                    <i class="fas fa-file-alt"></i> Caderneta Anual (A4)
                </a>
            <?php endif; ?>
            
            <button onclick="window.print()" class="bg-indigo-600 text-white py-2 px-4 rounded-lg hover:bg-indigo-700 transition flex items-center gap-2 text-sm font-semibold">
                <i class="fas fa-print"></i> Imprimir Mini-Pauta Trimestral
            </button>
        </div>
        <div class="print-table-container bg-white p-6 rounded-xl shadow-md">
            
             <div class="print-header hidden">
                <div class="header-insignia">
                    <img src="insignia/insignia.png" alt="Emblema da República">
                </div>
                
                <div class="header-text">
                    <p style="font-weight: bold; font-size: 11pt;"><?= htmlspecialchars($nome_republica) ?></p>
                    <p style="font-size: 10pt;"><?= htmlspecialchars($nome_governo) ?></p>
                    <p style="font-size: 10pt;"><?= htmlspecialchars($nome_gabinete) ?></p>
                    <p style="font-weight: bold; font-size: 11pt;"><?= htmlspecialchars($nome_escola) ?></p>
                </div>

                <p class="header-title">MINI-PAUTA DO <?= htmlspecialchars($trimestre_selecionado) ?>º TRIMESTRE</p>

                <div class="header-info" style="max-width: 90%; margin: 0 auto;">
                    <p>
                        <span class="info-label">Disciplina:</span>
                        <span class="info-value"><?= htmlspecialchars($nome_disciplina) ?></span>
                    </p>
                    <p>
                        <span class="info-label">Classe:</span>
                        <span class="info-value"><?= htmlspecialchars($classe_dinamica) ?></span>
                        <span class="info-label" style="padding-left: 15px;">Área:</span>
                        <span class="info-value"><?= htmlspecialchars($curso_area_dinamica) ?></span>
                    </p>
                    <p>
                        <span class="info-label">Turma:</span>
                        <span class="info-value"><?= htmlspecialchars($nome_turma_dinamica) ?></span>
                        <span class="info-label" style="padding-left: 15px;">Sala:</span>
                        <span class="info-value"><?= htmlspecialchars($sala_dinamica) ?></span>
                        <span class="info-label" style="padding-left: 15px;">Turno:</span>
                        <span class="info-value"><?= htmlspecialchars($turno_dinamico) ?></span>
                    </p>
                    <p>
                        <span class="info-label">Professor:</span>
                        <span class="info-value"><?= htmlspecialchars($nome_professor) ?></span>
                        <span class="info-label" style="padding-left: 15px;">Ano Lectivo:</span>
                        <span class="info-value"><?= htmlspecialchars($ano_lectivo_atual) ?></span>
                    </p>
                </div>
                <hr style="border: 0; border-top: 1px solid #000; margin: 10px 0;">
            </div>
            <h2 class="text-xl font-bold text-gray-700 mb-4 print-hidden"><?= htmlspecialchars($nome_disciplina) ?> - <?= htmlspecialchars($nome_turma_selecionada) ?> (<?= $trimestre_selecionado ?>º Trimestre)</h2>

            <?php
            // Determina se a edição está BLOQUEADA
            $edicao_bloqueada = $prazo_fechado || ($npt_bloqueado && !$is_simulating);
            $npt_readonly = $npt_bloqueado && !$is_simulating;
            $npp_readonly = $npp_bloqueado && !$is_simulating;
            ?>

            <form action="salvar_notas.php" method="POST" id="form-notas">
                
                <?php if ($is_simulating): ?>
                    <p class="text-yellow-700 font-semibold mb-4 print-hidden">AVISO: O Subdirector Pedagógico está em modo de edição e pode salvar alterações.</p>
                <?php elseif ($edicao_bloqueada): ?>
                    <p class="text-red-500 font-semibold mb-4 print-hidden">AVISO: O prazo de lançamento para este trimestre foi totalmente fechado para esta disciplina. Não é possível editar as notas. <?= htmlspecialchars($motivo_bloqueio_npt) ?></p>
                <?php endif; ?>
                
                <input type="hidden" name="salvar_notas" value="1">
                <input type="hidden" name="turma_id" value="<?= htmlspecialchars($turma_id) ?>">
                <input type="hidden" name="disciplina_id" value="<?= htmlspecialchars($disciplina_id) ?>">
                <input type="hidden" name="trimestre" value="<?= htmlspecialchars($trimestre_selecionado) ?>">

                <div class="overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead class="bg-blue-900 text-white">
                            <tr>
                                <th rowspan="2" class="coluna-nome-aluno-header">Nº</th>
                                <th rowspan="2" class="coluna-nome-aluno-header coluna-nome-aluno-tela">Nome Completo do Aluno</th>
                                <th colspan="3">Trimestre <?= htmlspecialchars($trimestre_selecionado) ?></th>
                                <?php if ($trimestre_selecionado == 3): ?>
                                <th colspan="6">Notas Finais</th> <?php endif; ?>
                                <th rowspan="2">OBS.</th>
                            </tr>
                            <tr>
                                <th>MAC</th>
                                <th>NPT</th>
                                <th>MT</th>
                                <?php if ($trimestre_selecionado == 3): ?>
                                <th>MFD</th>
                                <th>NEO</th>
                                <th>NEE</th>
                                <th>MEC</th>
                                <th>MF</th>
                                <th>ESTADO</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $contador = 1; ?>
                            <?php 
                            // Função auxiliar para formatar a nota
                            $formatar_nota = function($nota) {
                                return is_numeric($nota) ? number_format((float)$nota, 2, '.', '') : '';
                            };
                            
                            // Função auxiliar para determinar a classe de cor da nota
                            $determina_classe = function($nota) {
                                if (!is_numeric($nota)) return ''; 
                                $nota_float = (float)$nota; 
                                return ($nota_float >= 10.0) ? 'nota-aprovada' : 'nota-reprovada';
                            };
                            ?>


                            <?php foreach ($alunos as $aluno): 
                                $aluno_id = $aluno['id'];

                                // -----------------------------------------------------
                                // Notas do Trimestre Selecionado
                                // -----------------------------------------------------
                                $nota_atual = $notas_por_aluno[$aluno_id][$trimestre_selecionado] ?? [];
                                $mac_salvo = $nota_atual['mac'] ?? null;
                                $npt_salvo = $nota_atual['npt'] ?? null;
                                $mt_salvo = $nota_atual['mt'] ?? null;
                                $obs_salva = $nota_atual['obs'] ?? null;
                                
                                // Notas Finais (apenas no 3º trimestre)
                                $mfd_salvo = $nota_atual['mfd'] ?? null;
                                $neo_salvo = $nota_atual['neo'] ?? null;
                                $nee_salvo = $nota_atual['nee'] ?? null;
                                $mec_salvo = $nota_atual['mec'] ?? null;
                                $mf_salvo = $nota_atual['mf'] ?? null;

                                $mt_classe = $determina_classe($mt_salvo);
                                $mfd_classe = $determina_classe($mfd_salvo);
                                $mec_classe = $determina_classe($mec_salvo);
                                $mf_classe = $determina_classe($mf_salvo);

                                // Determinação inicial do estado final (apenas para exibição)
                                $estado_final_texto = '';
                                $estado_final_classe = 'estado-final-incompleto';
                                if (is_numeric($mf_salvo)) {
                                    if ((float)$mf_salvo >= 10.0) {
                                        $estado_final_texto = 'APROVADO';
                                        $estado_final_classe = 'estado-final-aprovado';
                                    } else {
                                        $estado_final_texto = 'REPROVADO';
                                        $estado_final_classe = 'estado-final-reprovado';
                                    }
                                }
                            ?>
                            <tr data-aluno-id="<?= $aluno_id ?>">
                                <td class="text-center"><?= $contador++ ?></td>
                                <td class="coluna-nome-aluno-tela coluna-nome-aluno"><?= htmlspecialchars($aluno['nome']) ?></td>

                                <!-- MAC (Input ou Valor) - Apenas exibição, pois é calculada na Caderneta -->
                                <td class="nota-calculada mac-cell print-value <?= $determina_classe($mac_salvo) ?>" data-nota-valor="<?= $formatar_nota($mac_salvo) ?>" data-mac-valor="<?= $formatar_nota($mac_salvo) ?>">
                                    <span class="print-hidden"><?= $formatar_nota($mac_salvo) ?></span>
                                    <input type="hidden" name="notas[<?= $aluno_id ?>][mac]" class="mac-input" value="<?= $formatar_nota($mac_salvo) ?>" disabled>
                                </td>
                                
                                <!-- NPT (Input) -->
                                <td class="print-value <?= $determina_classe($npt_salvo) ?>" data-nota-valor="<?= $formatar_nota($npt_salvo) ?>">
                                    <input type="number" step="0.01" min="0" max="20" 
                                        name="notas[<?= $aluno_id ?>][npt]" 
                                        value="<?= $formatar_nota($npt_salvo) ?>" 
                                        class="nota-input npt-input text-center print-hidden" 
                                        <?= $npt_readonly ? 'readonly' : '' ?>>
                                </td>
                                
                                <!-- MT (Calculado) -->
                                <td class="nota-calculada mt-cell print-value <?= $mt_classe ?>" data-nota-valor="<?= $formatar_nota($mt_salvo) ?>">
                                    <span class="mt-valor print-hidden"><?= $formatar_nota($mt_salvo) ?></span>
                                    <input type="hidden" name="notas[<?= $aluno_id ?>][mt]" class="mt-input" value="<?= $formatar_nota($mt_salvo) ?>">
                                </td>

                                <?php if ($trimestre_selecionado == 3): ?>
                                
                                <!-- MFD (Calculado) -->
                                <td class="nota-calculada mfd-cell print-value <?= $mfd_classe ?>" data-nota-valor="<?= $formatar_nota($mfd_salvo) ?>">
                                    <span class="mfd-valor print-hidden"><?= $formatar_nota($mfd_salvo) ?></span>
                                    <input type="hidden" name="notas[<?= $aluno_id ?>][mfd]" class="mfd-input" value="<?= $formatar_nota($mfd_salvo) ?>">
                                </td>
                                
                                <!-- NEO (Input) -->
                                <td class="print-value <?= $determina_classe($neo_salvo) ?>" data-nota-valor="<?= $formatar_nota($neo_salvo) ?>">
                                    <input type="number" step="0.01" min="0" max="20" 
                                        name="notas[<?= $aluno_id ?>][neo]" 
                                        value="<?= $formatar_nota($neo_salvo) ?>" 
                                        class="nota-input neo-input text-center print-hidden"
                                        <?= $npp_readonly ? 'readonly' : '' ?> />
                                </td>
                                
                                <!-- NEE (Input) -->
                                <td class="print-value <?= $determina_classe($nee_salvo) ?>" data-nota-valor="<?= $formatar_nota($nee_salvo) ?>">
                                    <input type="number" step="0.01" min="0" max="20" 
                                        name="notas[<?= $aluno_id ?>][nee]" 
                                        value="<?= $formatar_nota($nee_salvo) ?>" 
                                        class="nota-input nee-input text-center print-hidden"
                                        <?= $npp_readonly ? 'readonly' : '' ?> />
                                </td>

                                <!-- MEC (Calculado) -->
                                <td class="nota-calculada mec-cell print-value <?= $mec_classe ?>" data-nota-valor="<?= $formatar_nota($mec_salvo) ?>">
                                    <span class="mec-valor print-hidden"><?= $formatar_nota($mec_salvo) ?></span>
                                    <input type="hidden" name="notas[<?= $aluno_id ?>][mec]" class="mec-input" value="<?= $formatar_nota($mec_salvo) ?>">
                                </td>
                                
                                <!-- MF (Calculado) -->
                                <td class="nota-final-calc mf-cell print-value <?= $mf_classe ?>" data-nota-valor="<?= $formatar_nota($mf_salvo) ?>">
                                    <span class="mf-valor print-hidden"><?= $formatar_nota($mf_salvo) ?></span>
                                    <input type="hidden" name="notas[<?= $aluno_id ?>][mf]" class="mf-input" value="<?= $formatar_nota($mf_salvo) ?>">
                                </td>
                                
                                <!-- ESTADO (Calculado) -->
                                <td class="estado-cell print-value <?= $estado_final_classe ?>" data-nota-valor="<?= htmlspecialchars($estado_final_texto) ?>">
                                    <span class="estado-final-valor print-hidden"><?= htmlspecialchars($estado_final_texto) ?></span>
                                </td>
                                
                                <?php else: ?>
                                <!-- Células vazias para os trimestres 1 e 2 -->
                                <td colspan="6" class="bg-gray-100 text-gray-500 print-hidden">Cálculos Finais no 3º Trimestre</td>
                                <?php endif; ?>
                                
                                <!-- OBS (Input) -->
                                <td class="print-value" data-nota-valor="<?= htmlspecialchars($obs_salva) ?>">
                                    <input type="text" 
                                        name="notas[<?= $aluno_id ?>][obs]" 
                                        value="<?= htmlspecialchars($obs_salva) ?>" 
                                        class="nota-input text-center print-hidden"
                                        <?= $edicao_bloqueada ? 'readonly' : '' ?>>
                                </td>
                            </tr>
                            <?php endforeach; ?>

                        </tbody>
                    </table>
                </div>
                
                <?php if (!$edicao_bloqueada || $is_simulating): ?>
                    <div class="mt-6 print-hidden btn-salvar-notas text-center">
                        <button type="submit" class="bg-green-600 text-white py-3 px-8 rounded-xl hover:bg-green-700 transition font-bold shadow-lg">
                            <i class="fas fa-save"></i> Salvar Notas do <?= htmlspecialchars($trimestre_selecionado) ?>º Trimestre
                        </button>
                    </div>
                    <?php if ($npt_bloqueado && !$is_simulating): ?>
                        <p class="text-red-500 text-sm mt-2 text-center print-hidden"><?= htmlspecialchars($motivo_bloqueio_npt) ?></p>
                    <?php endif; ?>
                <?php endif; ?>
            </form>
            
            <!-- Rodapé de Assinaturas (Impressão) -->
            <div class="print-footer hidden">
                <p class="data-catumbela">
                    <?= htmlspecialchars($localidade) ?>, aos <span><?= date('d') ?></span> de <span><?= strftime('%B') ?></span> de <span><?= date('Y') ?></span>
                </p>
                <div class="footer-grid">
                    <div class="assinatura-box">
                        <div class="assinatura-linha"></div>
                        <p class="nome-assinado">O Professor(a): <?= htmlspecialchars($nome_professor) ?></p>
                    </div>
                    <div class="assinatura-box">
                        <div class="assinatura-linha"></div>
                        <p class="nome-assinado">O Sub-Director Pedagógico: <?= htmlspecialchars($nome_sub_diretor) ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded-xl shadow-md mt-6 print-hidden">
            <p class="font-bold">Aguardando Seleção</p>
            <p>Por favor, selecione uma Turma, uma Disciplina e o Trimestre para começar a lançar ou visualizar as notas.</p>
        </div>
    <?php endif; ?>

</main>

<!-- Lógica JavaScript e Scripts -->
<script>
// Toggle Sidebar para mobile
document.getElementById('menu-toggle').addEventListener('click', function() {
    document.getElementById('sidebar').classList.toggle('active');
    document.getElementById('overlay').classList.toggle('active');
});

document.getElementById('overlay').addEventListener('click', function() {
    document.getElementById('sidebar').classList.remove('active');
    this.classList.remove('active');
});

// Correção para manter a sidebar aberta no desktop
window.addEventListener('resize', function() {
    if (window.innerWidth >= 768) {
        document.getElementById('sidebar').classList.remove('active');
        document.getElementById('overlay').classList.remove('active');
    }
});

// Dados injetados do PHP para o JavaScript
const todasAsNotas = <?= $notas_js ?>; // Todas as notas de todos os trimestres
const trimestreAtual = <?= $trimestre_js ?>; // Trimestre selecionado (1, 2 ou 3)
const turmaId = '<?= htmlspecialchars($turma_id ?? 0) ?>';
const disciplinaId = '<?= htmlspecialchars($disciplina_id ?? 0) ?>';
</script>

<!-- Chamada do arquivo de cálculos -->
<script src="calculos.js"></script>

</body>
</html>