<?php
session_start();
include 'conexao.php';

// Acesso restrito
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

$alunos = $conn->query("SELECT id, nome FROM alunos ORDER BY nome")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Painel de Certificados</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f2f2f2;
            padding: 20px;
        }
        .painel-certificados {
            max-width: 800px;
            margin: auto;
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 8px rgba(0,0,0,0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 30px;
        }
        .aluno-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px;
            border-bottom: 1px solid #ccc;
        }
        .aluno-item:hover {
            background: #e6f0ff;
        }
        .aluno-item span {
            flex-grow: 1;
            padding-right: 20px;
            color: #333;
        }
        .aluno-item form {
            display: flex;
            gap: 10px;
        }
        .aluno-item button {
            padding: 8px 12px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            color: white;
            font-weight: bold;
        }
        .btn-normal {
            background-color: #007BFF;
        }
        .btn-qr {
            background-color: #28a745;
        }
    </style>
</head>
<body>

<div class="painel-certificados">
    <h2>Certificados dos Alunos</h2>
    <div class="lista-alunos">
        <?php foreach ($alunos as $aluno): ?>
            <div class="aluno-item">
                <span><?= htmlspecialchars($aluno['nome']) ?></span>
                <form action="certificado_final_modelo.php" method="GET" target="_blank">
                    <input type="hidden" name="aluno_id" value="<?= $aluno['id'] ?>">
                    <button type="submit" name="tipo" value="normal" class="btn-normal">Normal</button>
                    <button type="submit" name="tipo" value="qr" class="btn-qr">Com Código QR</button>
                </form>
            </div>
        <?php endforeach; ?>
    </div>
</div>

</body>
</html>