<?php
session_start();
// Verificação de login (se quiser)
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Painel Financeiro | SISMAG</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Google Fonts e Ícones -->
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <style>
    * {
      margin: 0; padding: 0; box-sizing: border-box;
      font-family: 'Roboto', sans-serif;
    }

    body {
      background: linear-gradient(to right, #0f2027, #203a43, #2c5364);
      color: #fff;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }

    header {
      background-color: #1a1a2e;
      padding: 20px;
      text-align: center;
      font-size: 24px;
      font-weight: bold;
      box-shadow: 0 2px 6px rgba(0,0,0,0.4);
      letter-spacing: 1px;
    }

    .container {
      flex: 1;
      padding: 30px 20px;
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 20px;
    }

    .card {
      background: rgba(255, 255, 255, 0.05);
      border: 1px solid rgba(255, 255, 255, 0.1);
      border-radius: 15px;
      padding: 30px 20px;
      text-align: center;
      transition: 0.3s;
      cursor: pointer;
    }

    .card:hover {
      background: rgba(255, 255, 255, 0.1);
      transform: translateY(-5px);
      box-shadow: 0 6px 20px rgba(0,0,0,0.3);
    }

    .card i {
      font-size: 40px;
      margin-bottom: 15px;
      color: #00d9ff;
    }

    .card h3 {
      font-size: 18px;
      font-weight: bold;
    }

    a {
      text-decoration: none;
      color: inherit;
    }

    @media (max-width: 600px) {
      header {
        font-size: 18px;
      }

      .card {
        padding: 20px 15px;
      }

      .card i {
        font-size: 30px;
      }

      .card h3 {
        font-size: 16px;
      }
    }
  </style>
</head>
<body>

<header>
  PAINEL FINANCEIRO - CEPEMILFRICKBG0026
</header>

<div class="container">


 <a href="resumo_geral.php">
    <div class="card">
      <i class="fas fa-arrow-down"></i>
      <h3>Resumo Geral</h3>
    </div>
  </a>
 

  <a href="registrar_receita.php">
    <div class="card">
      <i class="fas fa-arrow-down"></i>
      <h3>Registrar Receita</h3>
    </div>
  </a>

  <a href="registrar_despesa.php">
    <div class="card">
      <i class="fas fa-arrow-up"></i>
      <h3>Registrar Despesa</h3>
    </div>
  </a>

  <a href="relatorio_mensal.php">
    <div class="card">
      <i class="fas fa-chart-bar"></i>
      <h3>Relatório Mensal</h3>
    </div>
  </a>


  <a href="relatorio_trimestral.php">
    <div class="card">
      <i class="fas fa-chart-bar"></i>
      <h3>Relatório Trimestral</h3>
    </div>
  </a>

  <a href="relatorio_anual.php">
    <div class="card">
      <i class="fas fa-chart-bar"></i>
      <h3>Relatório Anual</h3>
    </div>
  </a>




  <a href="relatorio_detalhado.php">
    <div class="card">
      <i class="fas fa-list-alt"></i>
      <h3>Relatório Detalhado</h3>
    </div>
  </a>

  <a href="ver_movimentos.php">
    <div class="card">
      <i class="fas fa-calendar-alt"></i>
      <h3>Movimentos por Data</h3>
    </div>
  </a>

  <a href="gerar_pdf_financeiro.php">
    <div class="card">
      <i class="fas fa-file-pdf"></i>
      <h3>Gerar Resumo Financeiro Mensal em PDF</h3>
</div>
  </a>

  <a href="painel_subadmin.php">
    <div class="card">
      <i class="fas fa-file-pdf"></i>
      <h3>Início</h3>
    </div>
  </a>
</div>

</body>
</html>
