<?php
session_start();
include 'conexao.php';

// Verifica se o usuário é da Secretaria Geral
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SECRETARIA GERAL') {
    header("Location: login.php");
    exit;
}

$usuario = $_SESSION['usuario'];
$nome = htmlspecialchars($usuario['nome'] ?? 'Funcionário(a)');
$foto = htmlspecialchars($usuario['foto'] ?? 'sem-foto.png');
$mensagem_upload = '';

// LÓGICA PARA PROCESSAR O UPLOAD DA FOTO DE PERFIL
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['upload_foto'])) {
    if (isset($_FILES['nova_foto']) && $_FILES['nova_foto']['error'] === UPLOAD_ERR_OK) {
        $diretorio_destino = 'fotos/';
        $extensao = pathinfo($_FILES['nova_foto']['name'], PATHINFO_EXTENSION);
        // Gera um nome único para o arquivo para evitar colisões
        $foto_nova_nome = uniqid('perfil_') . '.' . $extensao;
        $caminho_completo = $diretorio_destino . $foto_nova_nome;

        if (move_uploaded_file($_FILES['nova_foto']['tmp_name'], $caminho_completo)) {
            // Atualiza o nome da foto no banco de dados
            $usuario_id = $_SESSION['usuario']['id'];
            $stmt = $conn->prepare("UPDATE usuarios SET foto = ? WHERE id = ?");
            $stmt->bind_param("si", $foto_nova_nome, $usuario_id);
            if ($stmt->execute()) {
                // Atualiza a variável de sessão para que a foto seja exibida imediatamente
                $_SESSION['usuario']['foto'] = $foto_nova_nome;
                $foto = $foto_nova_nome; // Atualiza a variável local
                $mensagem_upload = "✅ Foto de perfil atualizada com sucesso!";
            } else {
                $mensagem_upload = "❌ Erro ao atualizar o banco de dados.";
                // Remova a foto do servidor se o banco de dados falhar
                unlink($caminho_completo);
            }
            $stmt->close();
        } else {
            $mensagem_upload = "❌ Erro ao fazer o upload da foto.";
        }
    } else {
        $mensagem_upload = "⚠️ Por favor, selecione um arquivo de foto.";
    }
}

// Consultas
$totalAlunos = 0;
$admitidos = 0;
$propinas = 0;
$documentos = 0;

$ano_letivo_atual = '2025/2026';

// A T E N Ç Ã O: Consulta alterada para buscar o total de alunos unicamente na tabela 'alunos'
$res = $conn->query("SELECT COUNT(*) AS total FROM alunos");
if ($res && $row = $res->fetch_assoc()) {
    $totalAlunos = $row['total'];
}

$res = $conn->query("SELECT COUNT(*) AS total FROM alunos WHERE obs = 'Admitido'");
if ($res && $row = $res->fetch_assoc()) {
    $admitidos = $row['total'];
}

@$res = $conn->query("SELECT COUNT(*) AS total FROM propinas WHERE status = 'Pago'");
if ($res && $row = $res->fetch_assoc()) {
    $propinas = $row['total'];
}

@$res = $conn->query("SELECT COUNT(*) AS total FROM documentos WHERE destino = 'SECRETARIA GERAL'");
if ($res && $row = $res->fetch_assoc()) {
    $documentos = $row['total'];
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Painel - Secretaria Geral</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="js/chart.umd.js"></script>
    <link rel="stylesheet" href="css/all.min.css">
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
        }

        /* --- Estilos da barra superior (topbar) --- */
        .topbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #003366;
            color: white;
            height: 60px;
            padding: 0 20px;
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1000;
        }

        .topbar-left img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid white;
        }
        
        .menu-btn {
            display: none;
            color: white;
            font-size: 24px;
            cursor: pointer;
        }

        .topbar-center {
            flex: 1;
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            white-space: nowrap;
        }

        .topbar-right {
            font-size: 14px;
            font-weight: 500;
            white-space: nowrap;
        }
        
        /* --- Estilos da barra lateral (sidebar) --- */
        .sidebar {
            width: 230px;
            background: #001f3f;
            color: white;
            position: fixed;
            top: 60px;
            bottom: 0;
            padding-top: 20px;
            z-index: 999;
            transition: transform 0.3s ease-in-out;
        }

        .sidebar button {
            width: 100%;
            padding: 12px;
            background: none;
            border: none;
            text-align: left;
            color: white;
            font-size: 15px;
            cursor: pointer;
            transition: background 0.3s;
            display: flex;
            align-items: center;
        }

        .sidebar button i {
            margin-right: 10px;
            font-size: 18px;
        }

        .sidebar button:hover {
            background: #004080;
        }

        /* --- Estilos do conteúdo principal (content) --- */
        .content {
            margin-left: 230px;
            margin-top: 60px;
            padding: 30px;
            transition: margin-left 0.3s ease-in-out;
        }
        
        .dashboard {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
        }

        .card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            text-align: center;
        }

        .card h3 {
            margin-bottom: 10px;
            color: #003366;
        }

        .card p {
            font-size: 22px;
            font-weight: bold;
        }

        .graficos {
            margin-top: 40px;
            display: flex;
            flex-wrap: wrap;
            gap: 30px;
            justify-content: space-between;
        }

        .grafico {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            flex: 1;
            min-width: 280px;
            max-width: 600px;
        }

        .grafico canvas {
            width: 100% !important;
            height: 300px !important;
        }

        /* Estilos para a seção de upload da foto */
        .upload-section {
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
            text-align: center;
        }

        .upload-section h3 {
            color: #003366;
            margin-top: 0;
        }

        .upload-section input[type="file"] {
            border: 1px solid #ccc;
            padding: 8px;
            border-radius: 5px;
        }

        .upload-section button {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .upload-section button:hover {
            background-color: #0056b3;
        }
        
        /* Estilo da mensagem de sucesso/erro */
        .mensagem {
            margin-top: 10px;
            font-weight: bold;
        }
        .mensagem.sucesso {
            color: #28a745;
        }
        .mensagem.erro {
            color: #dc3545;
        }


        /* --- Media Queries para responsividade --- */
        @media (max-width: 768px) {
            .menu-btn {
                display: block;
            }

            .topbar-center {
                font-size: 16px;
                text-align: left;
            }

            .topbar-right {
                display: none;
            }
            
            .sidebar {
                width: 250px;
                transform: translateX(-250px);
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .content {
                margin-left: 0;
            }

            .dashboard {
                grid-template-columns: 1fr;
            }

            .grafico {
                min-width: 100%;
            }
        }
    </style>
</head>
<body>

<div class="topbar">
    <div class="menu-btn" onclick="toggleMenu()">
        <i class="fas fa-bars"></i>
    </div>
    <div class="topbar-left">
        <img src="fotos/<?= htmlspecialchars($foto) ?>" alt="Foto de Perfil">
    </div>
    <div class="topbar-center">
        <span>Bem-vindo, <?= htmlspecialchars($nome) ?></span>
    </div>
    <div class="topbar-right">
        <span>PAINEL DA SECRETARIA GERAL | Secretaria Geral</span>
    </div>
</div>

<div class="sidebar" id="sidebar">
    <button onclick="location.href='propinas.php'"><i class="fas fa-money-bill-wave"></i> Propinas</button>
    <button onclick="location.href='historico_propinas.php'"><i class="fas fa-history"></i> Histórico de Pagamentos</button>
    <button onclick="location.href='emitir_declaracoes.php'"><i class="fas fa-file-invoice"></i> Declarações</button>
    <button onclick="location.href='estatistica.php'"><i class="fas fa-user-check"></i> 📊 Estatística</button>
    <button onclick="location.href='matricular_aluno.php'"><i class="fas fa-user-check"></i> Matricular Aluno</button>
   <button onclick="location.href='editar_aluno.php'"><i class="fas fa-user-check"></i> Editar Aluno</button>



    <button onclick="location.href='lista_alunos_turma.php'"><i class="fas fa-list-ol"></i> Listas das turmas</button>
    <button onclick="location.href='ver_turmas.php'"><i class="fas fa-users"></i> Ver Turmas</button>
    <button onclick="location.href='cadastrar_turma1.php'"><i class="fas fa-chalkboard-teacher"></i> Cadastrar Turma</button>
    <button onclick="location.href='cadastrar_novos_alunos.php'"><i class="fas fa-user-friends"></i> Novos Alunos</button>
    <button onclick="location.href='cartao_estudante.php'"><i class="fas fa-address-card"></i> Cartão de Estudante</button>
    <button onclick="location.href='emitir_Rupes e Recibos.php'"><i class="fas fa-receipt"></i> Rupes e Recibos</button>
    <button onclick="location.href='documentos_recebidos.php'"><i class="fas fa-inbox"></i> Documentos Recebidos</button>
    <button onclick="location.href='enviar_documento.php'"><i class="fas fa-share-square"></i> Enviar Documento</button>
    <button onclick="location.href='alterar_senha.php'"><i class="fas fa-key"></i> Alterar Senha</button>

<button onclick="location.href='listadosfuncionarios.php'"><i class="fas fa-key"></i> Lista dos Id dos funcionários</button>





    <button onclick="location.href='login.php'"><i class="fas fa-sign-out-alt"></i> Sair</button>




</div>

<div class="content">
    <h2>Painel da Secretaria Geral</h2>
    
    <div class="upload-section">
        <h3>Atualizar Foto de Perfil</h3>
        <?php if (!empty($mensagem_upload)): ?>
            <div class="mensagem <?= strpos($mensagem_upload, '✅') !== false ? 'sucesso' : 'erro' ?>">
                <?= $mensagem_upload ?>
            </div>
        <?php endif; ?>
        <form action="" method="post" enctype="multipart/form-data">
            <input type="file" name="nova_foto" required>
            <button type="submit" name="upload_foto">Upload Foto</button>
        </form>
    </div>

    <div class="dashboard">
        <div class="card">
            <h3>Total de Alunos</h3>
            <p><?= $totalAlunos ?></p>
        </div>
        <div class="card">
            <h3>Admitidos</h3>
            <p><?= $admitidos ?></p>
        </div>
        <div class="card">
            <h3>Propinas em Dia</h3>
            <p><?= $propinas ?></p>
        </div>
        <div class="card">
            <h3>Documentos Recebidos</h3>
            <p><?= $documentos ?></p>
        </div>
    </div>

    <div class="graficos">
        <div class="grafico">
            <h3>Pagamentos por Classe</h3>
            <canvas id="graficoPizza"></canvas>
        </div>
        <div class="grafico">
            <h3>Entradas e Saídas</h3>
            <canvas id="graficoColuna"></canvas>
        </div>
    </div>
</div>

<script>
    function toggleMenu() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('active');
    }

    const ctxPizza = document.getElementById('graficoPizza').getContext('2d');
    new Chart(ctxPizza, {
        type: 'pie',
        data: {
            labels: ['10ª Classe', '11ª Classe', '12ª Classe', '13ª Classe'],
            datasets: [{
                data: [80, 60, 40, 20],
                backgroundColor: ['#007bff', '#28a745', '#ffc107', '#dc3545']
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { position: 'bottom' } }
        }
    });

    const ctxColuna = document.getElementById('graficoColuna').getContext('2d');
    new Chart(ctxColuna, {
        type: 'bar',
        data: {
            labels: ['Janeiro', 'Fevereiro', 'Março', 'Abril'],
            datasets: [
                {
                    label: 'Entradas (Kz)',
                    data: [1500000, 1300000, 1800000, 2000000],
                    backgroundColor: '#28a745'
                },
                {
                    label: 'Saídas (Kz)',
                    data: [1000000, 1100000, 900000, 1400000],
                    backgroundColor: '#dc3545'
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'top' }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Valor em Kz'
                    }
                }
            }
        }
    });
</script>

<script src="js/inatividade.js"></script>
</body>
</html>