<?php
session_start();
include 'conexao.php';

// Verifica se o usuário é da Secretaria Geral
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'ADMINISTRADOR') {
    header("Location: login.php");
    exit;
}

$usuario = $_SESSION['usuario'];
$nome = htmlspecialchars($usuario['nome'] ?? 'Funcionário(a)');
$foto = htmlspecialchars($usuario['foto'] ?? 'sem-foto.png');

// Consultas
$totalAlunos = 0;
$admitidos = 0;
$propinas = 0;
$documentos = 0;

// Total de alunos
$res = $conn->query("SELECT COUNT(*) AS total FROM alunos");
if ($res && $row = $res->fetch_assoc()) {
    $totalAlunos = $row['total'];
}

// Admitidos com observação
$res = $conn->query("SELECT COUNT(*) AS total FROM alunos WHERE obs = 'Admitido'");
if ($res && $row = $res->fetch_assoc()) {
    $admitidos = $row['total'];
}

// Propinas pagas (só se tabela existir)
@$res = $conn->query("SELECT COUNT(*) AS total FROM propinas WHERE status = 'Pago'");
if ($res && $row = $res->fetch_assoc()) {
    $propinas = $row['total'];
}

// Documentos recebidos por este setor
@$res = $conn->query("SELECT COUNT(*) AS total FROM documentos WHERE destino = 'SECRETARIA GERAL'");
if ($res && $row = $res->fetch_assoc()) {
    $documentos = $row['total'];
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Painel - Secretaria Geral</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="js/chart.umd.js"></script>
    <link rel="stylesheet" href="css/all.min.css">
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
        }

        /* --- Estilos da barra superior (topbar) --- */
        .topbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #003366;
            color: white;
            height: 60px;
            padding: 0 20px;
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1000;
        }

        .topbar-left img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid white;
        }
        
        /* Botão do menu hambúrguer, visível apenas em telas pequenas */
        .menu-btn {
            display: none;
            color: white;
            font-size: 24px;
            cursor: pointer;
        }

        .topbar-center {
            flex: 1;
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            white-space: nowrap;
        }

        .topbar-right {
            font-size: 14px;
            font-weight: 500;
            white-space: nowrap;
        }
        
        /* --- Estilos da barra lateral (sidebar) --- */
        .sidebar {
            width: 230px;
            background: #001f3f;
            color: white;
            position: fixed;
            top: 60px;
            bottom: 0;
            padding-top: 20px;
            z-index: 999;
            transition: transform 0.3s ease-in-out; /* Adicionado para animação */
        }

        .sidebar button {
            width: 100%;
            padding: 12px;
            background: none;
            border: none;
            text-align: left;
            color: white;
            font-size: 15px;
            cursor: pointer;
            transition: background 0.3s;
            display: flex;
            align-items: center;
        }

        .sidebar button i {
            margin-right: 10px;
            font-size: 18px;
        }

        .sidebar button:hover {
            background: #004080;
        }

        /* --- Estilos do conteúdo principal (content) --- */
        .content {
            margin-left: 230px;
            margin-top: 60px;
            padding: 30px;
            transition: margin-left 0.3s ease-in-out; /* Adicionado para animação */
        }

        .dashboard {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
        }

        .card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            text-align: center;
        }

        .card h3 {
            margin-bottom: 10px;
            color: #003366;
        }

        .card p {
            font-size: 22px;
            font-weight: bold;
        }

        .graficos {
            margin-top: 40px;
            display: flex;
            flex-wrap: wrap;
            gap: 30px;
            justify-content: space-between;
        }

        .grafico {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            flex: 1;
            min-width: 280px;
            max-width: 600px;
        }

        .grafico canvas {
            width: 100% !important;
            height: 300px !important;
        }

        /* --- Media Queries para responsividade --- */
        @media (max-width: 768px) {
            .menu-btn {
                display: block; /* Exibe o botão do menu */
            }

            .topbar-center {
                font-size: 16px;
                text-align: left; /* Alinha o nome do usuário à esquerda */
            }

            .topbar-right {
                display: none; /* Esconde o nome do sistema em telas pequenas */
            }
            
            .sidebar {
                width: 250px;
                transform: translateX(-250px); /* Esconde a barra lateral por padrão */
            }

            .sidebar.active {
                transform: translateX(0); /* Exibe a barra lateral quando a classe 'active' é adicionada */
            }

            .content {
                margin-left: 0; /* Remove a margem do conteúdo */
            }

            .dashboard {
                grid-template-columns: 1fr; /* Muda para uma coluna em telas pequenas */
            }

            .grafico {
                min-width: 100%; /* Ocupa toda a largura da tela */
            }
        }
    </style>
</head>
<body>

<div class="topbar">
    <div class="menu-btn" onclick="toggleMenu()">
        <i class="fas fa-bars"></i>
    </div>
    <div class="topbar-left">
        <img src="fotos/<?= htmlspecialchars($foto) ?>" alt="Foto">
    </div>
    <div class="topbar-center">
        <span>Bem-vindo, <?= htmlspecialchars($nome) ?></span>
    </div>
    <div class="topbar-right">
        <span>SISMAG | Secretaria Geral</span>
    </div>
</div>

<div class="sidebar" id="sidebar">
    <button onclick="location.href='propinas.php'"><i class="fas fa-money-bill-wave"></i> Propinas</button>
    <button onclick="location.href='historico_propinas.php'"><i class="fas fa-history"></i> Histórico de Pagamentos</button>
    <button onclick="location.href='emitir_declaracoes.php'"><i class="fas fa-file-invoice"></i> Declarações</button>
    <button onclick="location.href='matricular_aluno.php'"><i class="fas fa-user-check"></i> Matricular Aluno</button>
    <button onclick="location.href='lista_alunos_turma.php'"><i class="fas fa-list-ol"></i> Listas das turmas</button>
    <button onclick="location.href='ver_turmas.php'"><i class="fas fa-users"></i> Ver Turmas</button>
    <button onclick="location.href='cadastrar_turma1.php'"><i class="fas fa-chalkboard-teacher"></i> Cadastrar Turma</button>
    <button onclick="location.href='cadastrar_novos_alunos.php'"><i class="fas fa-user-friends"></i> Novos Alunos</button>
    <button onclick="location.href='cartao_estudante.php'"><i class="fas fa-address-card"></i> Cartão de Estudante</button>
    <button onclick="location.href='emitir_Rupes e Recibos.php'"><i class="fas fa-receipt"></i> Rupes e Recibos</button>
    <button onclick="location.href='documentos_recebidos.php'"><i class="fas fa-inbox"></i> Documentos Recebidos</button>
    <button onclick="location.href='enviar_documento.php'"><i class="fas fa-share-square"></i> Enviar Documento</button>
    <button onclick="location.href='alterar_senha.php'"><i class="fas fa-key"></i> Alterar Senha</button>
    <button onclick="location.href='login.php'"><i class="fas fa-sign-out-alt"></i> Sair</button>
</div>

<div class="content">
    <h2>Painel da Secretaria Geral</h2>
    <div class="dashboard">
        <div class="card">
            <h3>Total de Alunos</h3>
            <p><?= $totalAlunos ?></p>
        </div>
        <div class="card">
            <h3>Admitidos</h3>
            <p><?= $admitidos ?></p>
        </div>
        <div class="card">
            <h3>Propinas em Dia</h3>
            <p><?= $propinas ?></p>
        </div>
        <div class="card">
            <h3>Documentos Recebidos</h3>
            <p><?= $documentos ?></p>
        </div>
    </div>

    <div class="graficos">
        <div class="grafico">
            <h3>Pagamentos por Classe</h3>
            <canvas id="graficoPizza"></canvas>
        </div>
        <div class="grafico">
            <h3>Entradas e Saídas</h3>
            <canvas id="graficoColuna"></canvas>
        </div>
    </div>
</div>

<script>
    // Função para alternar a visibilidade da barra lateral em dispositivos móveis
    function toggleMenu() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('active');
    }

    // Gráfico de Pizza - Pagamento por Classe
    const ctxPizza = document.getElementById('graficoPizza').getContext('2d');
    new Chart(ctxPizza, {
        type: 'pie',
        data: {
            labels: ['10ª Classe', '11ª Classe', '12ª Classe', '13ª Classe'],
            datasets: [{
                data: [80, 60, 40, 20],
                backgroundColor: ['#007bff', '#28a745', '#ffc107', '#dc3545']
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { position: 'bottom' } }
        }
    });

    // Gráfico de Colunas - Entradas vs Saídas
    const ctxColuna = document.getElementById('graficoColuna').getContext('2d');
    new Chart(ctxColuna, {
        type: 'bar',
        data: {
            labels: ['Janeiro', 'Fevereiro', 'Março', 'Abril'],
            datasets: [
                {
                    label: 'Entradas (Kz)',
                    data: [1500000, 1300000, 1800000, 2000000],
                    backgroundColor: '#28a745'
                },
                {
                    label: 'Saídas (Kz)',
                    data: [1000000, 1100000, 900000, 1400000],
                    backgroundColor: '#dc3545'
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'top' }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Valor em Kz'
                    }
                }
            }
        }
    });
</script>
</body>
</html>