<?php
session_start();
include 'verifica_login.php';

// Verifica se o perfil é Subdirecção Administrativa
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'ADMINISTRADOR') {
    header("Location: login.php");
    exit;
}

$nome = $_SESSION['usuario']['nome'] ?? 'Usuário';
$foto = $_SESSION['usuario']['foto'] ?? 'sem-foto.png';
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Painel Subdirecção Administrativa</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f4f6f9; }
    .sidebar { width: 260px; background: #001f3f; color: white; position: fixed; top: 0; bottom: 0; padding-top: 60px; }
    .sidebar a { display: block; color: white; padding: 15px 20px; text-decoration: none; }
    .sidebar a:hover { background: #0056b3; }
    .topbar { position: fixed; left: 260px; right: 0; top: 0; height: 60px; background: #003366; color: white; display: flex; align-items: center; justify-content: space-between; padding: 0 20px; }
    .topbar .user-info { display: flex; align-items: center; gap: 10px; }
    .topbar img { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 2px solid white; }
    .main-content { margin-left: 260px; margin-top: 60px; padding: 30px; }

    .graficos-container {
      display: flex;
      flex-wrap: wrap;
      gap: 30px;
      margin-top: 40px;
    }

    .grafico-bloco {
      flex: 1;
      min-width: 300px;
      background: white;
      border-radius: 10px;
      padding: 20px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    .grafico-bloco canvas {
      width: 100%;
      height: 300px;
    }
  </style>
</head>
<body>

  <div class="sidebar">



    <a href="painel_financeiro.php"><i class="fas fa-file-invoice-dollar"></i> Painel Financeiro</a>
    <a href="remuneracao.php"><i class="fas fa-file-invoice-dollar"></i> Remuneração(pessoal eventual)</a>
    <a href="recursos_humanos.php"><i class="fas fa-users"></i> Recursos Humanos</a>
    <a href="patrimonio_logistica.php"><i class="fas fa-boxes"></i> Património e Logística</a>
        <a href="rupes_recibos.php"><i class="fas fa-receipt"></i> Rupes e Recibos</a>
    <a href="documentos_recebidos.php"><i class="fas fa-folder-open"></i> Documentos Recebidos</a>
    <a href="enviar_documento.php"><i class="fas fa-upload"></i> Enviar Documento</a>
    <a href="alterar_senha.php"><i class="fas fa-upload"></i>Alterar Senha</a>
      <a href="propinas.php"><i class="fas fa-boxes"></i>Cadastro de Propinas/Comparticipação</a>
      <a href="historico_propinas.php"><i class="fas fa-boxes"></i>Histórico de Propinas/Comparticipação</a>

    <a href="login.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
</div>


  <div class="topbar">
    <strong>SISMAG | Subdirecção Administrativa</strong>
    <div class="user-info">
      <span><?= htmlspecialchars($nome) ?></span>
      <img src="fotos/<?= htmlspecialchars($foto) ?>" alt="Foto do usuário">
    </div>
  </div>

 <div class="main-content">
  <h2>Bem-vindo(a), <?= htmlspecialchars($nome) ?>!</h2>
  <p>Selecione uma funcionalidade na barra lateral.</p>

  <div class="graficos-container" style="display: flex; flex-wrap: wrap; gap: 30px; justify-content: space-around; padding: 20px;">

    <!-- Gráfico de Pizza: Pagamento de Propinas -->
    <div class="grafico-bloco" style="flex: 1 1 400px; max-width: 600px;">
      <h4 style="color:#003366;">Pagamento de Propinas por Classe</h4>
      <canvas id="graficoPropinas"></canvas>
    </div>

    <!-- Gráfico de Colunas: Entradas e Saídas -->
    <div class="grafico-bloco" style="flex: 1 1 400px; max-width: 600px;">
      <h4 style="color:#003366;">Fluxo Financeiro</h4>
      <canvas id="graficoEntradasSaidas"></canvas>
    </div>

  </div>
</div>

<script>
  // Gráfico de pizza: Pagamento por classe
  const ctxPropinas = document.getElementById('graficoPropinas').getContext('2d');
  new Chart(ctxPropinas, {
    type: 'pie',
    data: {
      labels: ['10ª Classe', '11ª Classe', '12ª Classe', '13ª Classe'],
      datasets: [{
        label: 'Valor Pago (Kz)',
        data: [500000, 350000, 250000, 150000],
        backgroundColor: ['#007bff', '#28a745', '#ffc107', '#dc3545'],
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: {
          position: 'bottom'
        }
      }
    }
  });

  // Gráfico de colunas: Entradas e Saídas
  const ctxFinanceiro = document.getElementById('graficoEntradasSaidas').getContext('2d');
  new Chart(ctxFinanceiro, {
    type: 'bar',
    data: {
      labels: ['Janeiro', 'Fevereiro', 'Março', 'Abril'],
      datasets: [
        {
          label: 'Entradas (Kz)',
          data: [400000, 350000, 420000, 380000],
          backgroundColor: '#28a745'
        },
        {
          label: 'Saídas (Kz)',
          data: [250000, 200000, 300000, 270000],
          backgroundColor: '#dc3545'
        }
      ]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'top' }
      },
      scales: {
        y: {
          beginAtZero: true,
          title: { display: true, text: 'Valores (Kz)' }
        }
      }
    }
  });
</script>

