<?php
session_start();
include 'conexao.php';

$aluno_id = (int)($_SESSION['aluno']['id'] ?? 0);
$ano_lectivo_atual = '2025/2026'; // Mantenha isso fixo para o ano letivo
date_default_timezone_set('Africa/Luanda'); // Define o fuso horário para Luanda

if ($aluno_id <= 0) {
    header('Location: login.php');
    exit;
}

$dados_aluno = null;
$sqlAluno = "
    SELECT a.nome, t.nome AS turma_nome, t.classe, t.curso, t.turno
    FROM alunos a
    INNER JOIN turmas t ON a.turma_id = t.id
    WHERE a.id = ?
";
$stmtAluno = $conn->prepare($sqlAluno);
$stmtAluno->bind_param("i", $aluno_id);
$stmtAluno->execute();
$resultadoAluno = $stmtAluno->get_result();
if ($resultadoAluno->num_rows > 0) {
    $dados_aluno = $resultadoAluno->fetch_assoc();
}
$stmtAluno->close();

// --- CÓDIGO DE VERIFICAÇÃO DE PAGAMENTO AJUSTADO ---
// Mapeia os nomes dos meses em inglês para português
$meses_pt = [
    'January' => 'Janeiro', 'February' => 'Fevereiro', 'March' => 'Março',
    'April' => 'Abril', 'May' => 'Maio', 'June' => 'Junho',
    'July' => 'Julho', 'August' => 'Agosto', 'September' => 'Setembro',
    'October' => 'Outubro', 'November' => 'Novembro', 'December' => 'Dezembro'
];
$mes_ingles_atual = date('F'); // Nome do mês atual em inglês
$mes_atual = $meses_pt[$mes_ingles_atual] ?? 'Mês inválido'; // Converte para português
$ano_atual = date('Y'); // Ano atual

// A consulta agora usa o nome do mês em português e a coluna 'mes'
$sql_check_pagamento = "
    SELECT id FROM propinas 
    WHERE aluno_id = ? AND mes = ? AND ano = ?
    LIMIT 1
";
$stmt_check = $conn->prepare($sql_check_pagamento);
$stmt_check->bind_param("isi", $aluno_id, $mes_atual, $ano_atual);
$stmt_check->execute();
$res_check = $stmt_check->get_result();
$propina_paga_mes_atual = ($res_check->num_rows > 0);
$stmt_check->close();

// --- FIM DO CÓDIGO DE VERIFICAÇÃO ---

$sqlNotas = "
    SELECT 
        d.nome AS disciplina_nome,
        n.mt1,
        n.mt2,
        n.mt3
    FROM notas n
    INNER JOIN disciplinas d ON n.disciplina_id = d.id
    WHERE n.aluno_id = ? AND n.ano_lectivo = ?
    ORDER BY d.nome
";
$stmtNotas = $conn->prepare($sqlNotas);
$stmtNotas->bind_param("is", $aluno_id, $ano_lectivo_atual);
$stmtNotas->execute();
$resultadoNotas = $stmtNotas->get_result();

$notas_por_disciplina = [];
$disciplinas_com_nota_baixa = 0;

while ($linha = $resultadoNotas->fetch_assoc()) {
    $disciplina = $linha['disciplina_nome'];
    
    $mt1 = (float) ($linha['mt1'] ?? 0);
    $mt2 = (float) ($linha['mt2'] ?? 0);
    $mt3 = (float) ($linha['mt3'] ?? 0);
    
    $mfd = ($mt1 + $mt2 + $mt3) / 3;
    $mf = round($mfd); 
    
    $notas_por_disciplina[$disciplina] = [
        'mt1' => number_format($mt1, 2, '.', ''),
        'mt2' => number_format($mt2, 2, '.', ''),
        'mt3' => number_format($mt3, 2, '.', ''),
        'mfd' => number_format($mfd, 2, '.', ''),
        'mf'  => number_format($mf, 0, '.', '')
    ];

    if ($mf < 10) {
        $disciplinas_com_nota_baixa++;
    }
}

if ($disciplinas_com_nota_baixa === 0) {
    $observacao_final = 'Transita';
} elseif ($disciplinas_com_nota_baixa <= 3) {
    $observacao_final = 'Conselho';
} else {
    $observacao_final = 'Não Transita';
}

$stmtNotas->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Pauta Final</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { font-family: 'Inter', sans-serif; }
        .nota-baixa { color: #ef4444; font-weight: bold; }
        .nota-suficiente { color: #22c55e; font-weight: bold; }
        
        @media print {
            @page { size: a4 portrait; margin: 0; }
            body { background-color: #fff !important; font-size: 10px; padding: 0 !important; margin: 0 !important; }
            .no-print { display: none !important; }
            .print-header { display: block !important; text-align: center; margin-bottom: 10px; }
            table { width: 100%; font-size: 9px; }
            th, td { padding: 3px !important; }
        }
    </style>
    <script>
        function pintarNotas() {
            document.querySelectorAll('td.nota').forEach(cell => {
                const nota = parseFloat(cell.textContent.replace(',', '.'));
                if (!isNaN(nota)) {
                    if (nota < 10) {
                        cell.classList.add('nota-baixa');
                        cell.classList.remove('nota-suficiente');
                    } else {
                        cell.classList.add('nota-suficiente');
                        cell.classList.remove('nota-baixa');
                    }
                }
            });
        }
        document.addEventListener('DOMContentLoaded', pintarNotas);
    </script>
</head>
<body class="bg-gray-100 text-gray-800 p-4 sm:p-8">

<div class="no-print fixed top-4 right-4 z-50">
    <button onclick="window.print()" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg shadow-lg transition-colors">Imprimir</button>
    <a href="painel_aluno.php" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded-lg shadow-lg transition-colors">Voltar</a>
</div>

<div class="max-w-7xl mx-auto bg-white rounded-xl shadow-lg p-6 sm:p-10">
    <header class="text-center mb-4 sm:mb-8">
        <img src="insignia/insignia.png" alt="Insígnia" class="w-16 sm:w-24 mx-auto mb-2 sm:mb-4">
        <h1 class="text-sm sm:text-lg">REPÚBLICA DE ANGOLA</h1>
        <h2 class="text-sm sm:text-lg">GOVERNO PROVINCIAL DE BENGUELA</h2>
        <h2 class="text-sm sm:text-lg">GABINETE PROVINCIAL DA EDUCAÇÃO</h2>
        <h2 class="text-sm sm:text-lg">COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK – CATUMBELA</h2>
        <h2 class="text-base sm:text-xl font-bold">PAUTA FINAL</h2>
    </header>

    <?php if ($dados_aluno): ?>

    <?php if ($propina_paga_mes_atual): ?>
        <div class="mb-6 p-4 rounded-lg shadow-sm bg-gray-50 flex flex-col sm:flex-row justify-between items-center text-sm sm:text-base">
            <div class="mb-2 sm:mb-0">
                <p><span class="font-bold">Aluno:</span> <?= htmlspecialchars($dados_aluno['nome']) ?></p>
                <p><span class="font-bold">Turma:</span> <?= htmlspecialchars($dados_aluno['turma_nome']) ?></p>
            </div>
            <div>
                <p><span class="font-bold">Classe:</span> <?= htmlspecialchars($dados_aluno['classe']) ?></p>
                <p><span class="font-bold">Curso:</span> <?= htmlspecialchars($dados_aluno['curso']) ?></p>
            </div>
        </div>
    
        <div class="overflow-x-auto rounded-lg shadow-md border border-gray-200">
            <table class="min-w-full text-xs sm:text-sm text-left text-gray-600">
                <thead class="text-xs text-gray-700 uppercase bg-blue-100">
                    <tr>
                        <th scope="col" class="py-2 px-1 text-center">DISCIPLINA</th>
                        <th scope="col" class="py-2 px-1 text-center">1º TRIMESTRE (MT)</th>
                        <th scope="col" class="py-2 px-1 text-center">2º TRIMESTRE (MT)</th>
                        <th scope="col" class="py-2 px-1 text-center">3º TRIMESTRE (MT)</th>
                        <th scope="col" class="py-2 px-1 text-center">MFD</th>
                        <th scope="col" class="py-2 px-1 text-center">MF</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($notas_por_disciplina as $disciplina_nome => $notas): ?>
                    <tr class="bg-white border-b hover:bg-gray-50">
                        <td class="py-2 px-1 font-bold"><?= htmlspecialchars($disciplina_nome) ?></td>
                        <td class="py-2 px-1 text-center font-bold nota"><?= htmlspecialchars($notas['mt1']) ?></td>
                        <td class="py-2 px-1 text-center font-bold nota"><?= htmlspecialchars($notas['mt2']) ?></td>
                        <td class="py-2 px-1 text-center font-bold nota"><?= htmlspecialchars($notas['mt3']) ?></td>
                        <td class="py-2 px-1 text-center font-bold nota"><?= htmlspecialchars($notas['mfd']) ?></td>
                        <td class="py-2 px-1 text-center font-bold nota"><?= htmlspecialchars($notas['mf']) ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-6 p-4 rounded-lg shadow-sm bg-gray-50 text-sm sm:text-base text-center">
            <p class="font-bold mt-2">Observação:
                <?php 
                    $cor = 'text-gray-600';
                    if ($observacao_final === 'Transita') {
                        $cor = 'text-green-600';
                    } elseif ($observacao_final === 'Não Transita') {
                        $cor = 'text-red-600';
                    }
                ?>
                <span class="<?= $cor ?>"><?= htmlspecialchars($observacao_final) ?></span>
            </p>
        </div>

    <?php else: ?>
        <div class="p-6 text-center bg-red-100 border border-red-400 text-red-700 rounded-lg">
            <h3 class="text-lg sm:text-xl font-bold mb-2">Acesso Restrito</h3>
            <p>A pauta não pode ser exibida. Por favor, regularize o pagamento da propina do mês de **<?= htmlspecialchars(ucfirst($mes_atual)) ?>**.</p>
        </div>
    <?php endif; ?>
    
    <?php endif; ?>
</div>

</body>
</html>