<?php
session_start();
require_once __DIR__ . '/conexao.php';

// Verificação de acesso e CSRF Token
if (!isset($_SESSION['usuario']['id'])) {
    die('Acesso negado. Faça login para continuar.');
}

if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf = $_SESSION['csrf_token'];

$success_message = '';
$error_message = '';

// Processar formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!hash_equals($csrf, $_POST['csrf_token'] ?? '')) {
        $error_message = 'Erro de segurança. Tente novamente.';
    } else {
        $usuario_id = $_SESSION['usuario']['id'];

        // Mapeamento e sanitização dos dados do formulário
        $ano_lectivo = $_POST['ano_lectivo'] ?? null;
        $classe = $_POST['classe'] ?? null;
        $disciplina = $_POST['disciplina'] ?? null;
        $trimestre = $_POST['trimestre'] ?? null;
        $mes = $_POST['mes'] ?? null;
        $data_planificacao = $_POST['data_planificacao'] ?? null;
        $data_catumbela = $_POST['data_catumbela'] ?? null;
        $participantes = $_POST['participantes'] ?? null;

        // Planificação - Semanas
        $semana1_de = $_POST['semana1_de'] ?? null;
        $semana1_ate = $_POST['semana1_ate'] ?? null;
        $semana1_conteudo = $_POST['semana1_conteudo'] ?? null;
        $semana1_obs = $_POST['semana1_obs'] ?? null;

        $semana2_de = $_POST['semana2_de'] ?? null;
        $semana2_ate = $_POST['semana2_ate'] ?? null;
        $semana2_conteudo = $_POST['semana2_conteudo'] ?? null;
        $semana2_obs = $_POST['semana2_obs'] ?? null;

        $semana3_de = $_POST['semana3_de'] ?? null;
        $semana3_ate = $_POST['semana3_ate'] ?? null;
        $semana3_conteudo = $_POST['semana3_conteudo'] ?? null;
        $semana3_obs = $_POST['semana3_obs'] ?? null;

        $semana4_de = $_POST['semana4_de'] ?? null;
        $semana4_ate = $_POST['semana4_ate'] ?? null;
        $semana4_conteudo = $_POST['semana4_conteudo'] ?? null;
        $semana4_obs = $_POST['semana4_obs'] ?? null;

        // Dados da Acta
        $acta_numero = $_POST['acta_numero'] ?? null;
        $data_reuniao_acta = $_POST['data_reuniao_acta'] ?? null;
        $coordenador_disciplina = $_POST['coordenador_disciplina'] ?? null;
        $professores_acta = $_POST['professores_acta'] ?? null;

        $acta_conteudo1 = $_POST['acta_conteudo1'] ?? null;
        $acta_objetivos_gerais1 = $_POST['acta_objetivos_gerais1'] ?? null;
        $acta_objetivos_especificos1 = $_POST['acta_objetivos_especificos1'] ?? null;
        $acta_metodos1 = $_POST['acta_metodos1'] ?? null;
        $acta_meios1 = $_POST['acta_meios1'] ?? null;
        
        $acta_conteudo2 = $_POST['acta_conteudo2'] ?? null;
        $acta_objetivos_gerais2 = $_POST['acta_objetivos_gerais2'] ?? null;
        $acta_objetivos_especificos2 = $_POST['acta_objetivos_especificos2'] ?? null;
        $acta_metodos2 = $_POST['acta_metodos2'] ?? null;
        $acta_meios2 = $_POST['acta_meios2'] ?? null;
        
        $acta_conteudo3 = $_POST['acta_conteudo3'] ?? null;
        $acta_objetivos_gerais3 = $_POST['acta_objetivos_gerais3'] ?? null;
        $acta_objetivos_especificos3 = $_POST['acta_objetivos_especificos3'] ?? null;
        $acta_metodos3 = $_POST['acta_metodos3'] ?? null;
        $acta_meios3 = $_POST['acta_meios3'] ?? null;
        
        $acta_conteudo4 = $_POST['acta_conteudo4'] ?? null;
        $acta_objetivos_gerais4 = $_POST['acta_objetivos_gerais4'] ?? null;
        $acta_objetivos_especificos4 = $_POST['acta_objetivos_especificos4'] ?? null;
        $acta_metodos4 = $_POST['acta_metodos4'] ?? null;
        $acta_meios4 = $_POST['acta_meios4'] ?? null;

        // A consulta SQL foi ajustada para corresponder à ordem das colunas na sua tabela.
        $stmt = $conn->prepare("INSERT INTO planificacoes_mensais (
            usuario_id, ano_lectivo, classe, disciplina, trimestre, mes, data_planificacao,
            semana1_de, semana1_ate, semana1_conteudo, semana1_obs,
            semana2_de, semana2_ate, semana2_conteudo, semana2_obs,
            semana3_de, semana3_ate, semana3_conteudo, semana3_obs,
            semana4_de, semana4_ate, semana4_conteudo, semana4_obs,
            acta_numero, acta_data, coordenador, acta_participantes,
            acta_conteudo1, acta_objetivos_gerais1, acta_objetivos_especificos1, acta_metodos1, acta_meios1,
            acta_conteudo2, acta_objetivos_gerais2, acta_objetivos_especificos2, acta_metodos2, acta_meios2,
            acta_conteudo3, acta_objetivos_gerais3, acta_objetivos_especificos3, acta_metodos3, acta_meios3,
            acta_conteudo4, acta_objetivos_gerais4, acta_objetivos_especificos4, acta_metodos4, acta_meios4,
            data_catumbela, participantes
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        
        // A string de tipos e as variáveis foram corrigidas. A contagem agora é de 49.
        $stmt->bind_param('issssssssssssssssssssssssssssssssssssssssssssssss',
            $usuario_id, $ano_lectivo, $classe, $disciplina, $trimestre, $mes, $data_planificacao,
            $semana1_de, $semana1_ate, $semana1_conteudo, $semana1_obs,
            $semana2_de, $semana2_ate, $semana2_conteudo, $semana2_obs,
            $semana3_de, $semana3_ate, $semana3_conteudo, $semana3_obs,
            $semana4_de, $semana4_ate, $semana4_conteudo, $semana4_obs,
            $acta_numero, $data_reuniao_acta, $coordenador_disciplina, $professores_acta,
            $acta_conteudo1, $acta_objetivos_gerais1, $acta_objetivos_especificos1, $acta_metodos1, $acta_meios1,
            $acta_conteudo2, $acta_objetivos_gerais2, $acta_objetivos_especificos2, $acta_metodos2, $acta_meios2,
            $acta_conteudo3, $acta_objetivos_gerais3, $acta_objetivos_especificos3, $acta_metodos3, $acta_meios3,
            $acta_conteudo4, $acta_objetivos_gerais4, $acta_objetivos_especificos4, $acta_metodos4, $acta_meios4,
            $data_catumbela, $participantes
        );

        if ($stmt->execute()) {
            $success_message = 'Dados salvos com sucesso!';
        } else {
            $error_message = 'Erro ao salvar os dados: ' . $stmt->error;
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Modelo de Planificação e Acta</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <style>
        * { box-sizing: border-box; }
        body { font-family: 'Segoe UI', sans-serif; margin: 0; padding: 0; background: #f5f5f5; color: #222; }
        .page { background: #fff; width: 100%; max-width: 900px; margin: 20px auto; padding: 40px; box-shadow: 0 0 8px rgba(0,0,0,0.1); page-break-after: always; }
        .message { padding: 10px; margin-bottom: 20px; border-radius: 5px; }
        .message.success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .message.error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .header { text-align: center; margin-bottom: 25px; }
        .logo-centro img { display: block; margin: 0 auto; width: 80px; height: auto; }
        .texto-cabecalho { font-weight: bold; line-height: 1.5; margin-top: 10px; }
        h2 { text-align: center; margin-top: 20px; text-transform: uppercase; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; margin-bottom: 25px; }
        table, td, th { border: 1px solid #333; }
        td { padding: 10px; vertical-align: top; }
        .assinaturas { margin-top: 40px; }
        .assinaturas div { margin-top: 15px; }
        .semana-titulo { background-color: #eee; font-weight: bold; }
        .obs { text-align: right; font-style: italic; padding-top: 5px; }
        input[type="text"], input[type="date"], textarea { width: 100%; padding: 5px; border: 1px solid #ccc; border-radius: 4px; }
        .btn { display: block; width: 200px; margin: 20px auto; padding: 10px; background-color: #007BFF; color: white; text-align: center; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; }
        .btn:hover { background-color: #0056b3; }
        p > input { width: auto; }
        @media print {
            body { background: none; }
            .page { box-shadow: none; margin: 0; padding: 20mm; page-break-after: always; }
            .message, .btn { display: none; }
            input, textarea { border: none; }
            p > input, table input { border: none; }
        }
    </style>
</head>
<body>

<?php if ($success_message): ?>
<div class="message success"><?= htmlspecialchars($success_message) ?></div>
<?php endif; ?>
<?php if ($error_message): ?>
<div class="message error"><?= htmlspecialchars($error_message) ?></div>
<?php endif; ?>

<form method="POST">
<input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">

<div class="page">
    <div class="header">
        <div class="logo-centro">
            <img src="insignia/insignia.png" alt="Insígnia">
        </div>
        <div class="texto-cabecalho">
            REPÚBLICA DE ANGOLA<br>
            GOVERNO PROVINCIAL DE BENGUELA<br>
            GABINETE PROVINCIAL DA EDUCAÇÃO<br>
            COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK – CATUMBELA
        </div>
    </div>

    <h2>PLANIFICAÇÃO MENSAL</h2>

    <table>
        <tr>
            <td>ANO LECTIVO: <input type="text" name="ano_lectivo" placeholder="Ex: 2024/2025" required></td>
            <td>CLASSE: <input type="text" name="classe" required></td>
            <td>MÊS DE: <input type="text" name="mes" required></td>
        </tr>
        <tr>
            <td>DISCIPLINA: <input type="text" name="disciplina" required></td>
            <td>TRIMESTRE: <input type="text" name="trimestre" required></td>
            <td>DATA: <input type="date" name="data_planificacao" required></td>
        </tr>
    </table>

    <table>
        <tr class="semana-titulo"><td colspan="2">1ª SEMANA</td></tr>
        <tr>
            <td>De: <input type="date" name="semana1_de"></td>
            <td>Até: <input type="date" name="semana1_ate"></td>
        </tr>
        <tr>
            <td colspan="2" style="height: 100px;"><textarea name="semana1_conteudo" rows="4" placeholder="Conteúdo da semana..."></textarea></td>
        </tr>
        <tr><td colspan="2" class="obs">Obs: <input type="text" name="semana1_obs" placeholder="Observações da semana..."></td></tr>
    </table>

    <table>
        <tr class="semana-titulo"><td colspan="2">2ª SEMANA</td></tr>
        <tr>
            <td>De: <input type="date" name="semana2_de"></td>
            <td>Até: <input type="date" name="semana2_ate"></td>
        </tr>
        <tr>
            <td colspan="2" style="height: 100px;"><textarea name="semana2_conteudo" rows="4" placeholder="Conteúdo da semana..."></textarea></td>
        </tr>
        <tr><td colspan="2" class="obs">Obs: <input type="text" name="semana2_obs" placeholder="Observações da semana..."></td></tr>
    </table>

    <table>
        <tr class="semana-titulo"><td colspan="2">3ª SEMANA</td></tr>
        <tr>
            <td>De: <input type="date" name="semana3_de"></td>
            <td>Até: <input type="date" name="semana3_ate"></td>
        </tr>
        <tr>
            <td colspan="2" style="height: 100px;"><textarea name="semana3_conteudo" rows="4" placeholder="Conteúdo da semana..."></textarea></td>
        </tr>
        <tr><td colspan="2" class="obs">Obs: <input type="text" name="semana3_obs" placeholder="Observações da semana..."></td></tr>
    </table>

    <table>
        <tr class="semana-titulo"><td colspan="2">4ª SEMANA</td></tr>
        <tr>
            <td>De: <input type="date" name="semana4_de"></td>
            <td>Até: <input type="date" name="semana4_ate"></td>
        </tr>
        <tr>
            <td colspan="2" style="height: 100px;"><textarea name="semana4_conteudo" rows="4" placeholder="Conteúdo da semana..."></textarea></td>
        </tr>
        <tr><td colspan="2" class="obs">Obs: <input type="text" name="semana4_obs" placeholder="Observações da semana..."></td></tr>
    </table>

    <div class="assinaturas">
        <p>Catumbela, <input type="date" name="data_catumbela"></p>
        <strong>Participantes:</strong>
        <textarea name="participantes" rows="5" placeholder="Liste os participantes, um por linha."></textarea>
    </div>
</div>

<div class="page">
    <div class="header">
        <div class="logo-centro">
            <img src="insignia/insignia.png" alt="Insígnia">
        </div>
        <div class="texto-cabecalho">
            REPÚBLICA DE ANGOLA<br>
            GOVERNO PROVINCIAL DE BENGUELA<br>
            GABINETE PROVINCIAL DA EDUCAÇÃO<br>
            COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK – CATUMBELA<br><br>
            SUBDIREÇÃO PEDAGÓGICA
        </div>
    </div>

    <h2>ACTA DA REUNIÃO DE COORDENAÇÃO</h2>

    <p>Acta nº <input type="text" name="acta_numero"> da Reunião de Coordenação da Disciplina de <input type="text" name="disciplina_acta">, realizada aos <input type="date" name="data_reuniao_acta">, sob orientação do(a) Coordenador(a), ladeado(a) pelos seguintes professores:</p>
    <textarea name="professores_acta" rows="3" placeholder="Insira aqui os nomes dos professores participantes."></textarea>

    <h3>1ª Semana</h3>
    <p>Conteúdo: <input type="text" name="acta_conteudo1"></p>
    <p>Objetivos Gerais: <input type="text" name="acta_objetivos_gerais1"></p>
    <p>Objetivos Específicos: <input type="text" name="acta_objetivos_especificos1"></p>
    <p>Métodos: <input type="text" name="acta_metodos1"></p>
    <p>Meios: <input type="text" name="acta_meios1"></p>

    <h3>2ª Semana</h3>
    <p>Conteúdo: <input type="text" name="acta_conteudo2"></p>
    <p>Objetivos Gerais: <input type="text" name="acta_objetivos_gerais2"></p>
    <p>Objetivos Específicos: <input type="text" name="acta_objetivos_especificos2"></p>
    <p>Métodos: <input type="text" name="acta_metodos2"></p>
    <p>Meios: <input type="text" name="acta_meios2"></p>

    <h3>3ª Semana</h3>
    <p>Conteúdo: <input type="text" name="acta_conteudo3"></p>
    <p>Objetivos Gerais: <input type="text" name="acta_objetivos_gerais3"></p>
    <p>Objetivos Específicos: <input type="text" name="acta_objetivos_especificos3"></p>
    <p>Métodos: <input type="text" name="acta_metodos3"></p>
    <p>Meios: <input type="text" name="acta_meios3"></p>

    <h3>4ª Semana</h3>
    <p>Conteúdo: <input type="text" name="acta_conteudo4"></p>
    <p>Objetivos Gerais: <input type="text" name="acta_objetivos_gerais4"></p>
    <p>Objetivos Específicos: <input type="text" name="acta_objetivos_especificos4"></p>
    <p>Métodos: <input type="text" name="acta_metodos4"></p>
    <p>Meios: <input type="text" name="acta_meios4"></p>

    <br><br>
    <p><strong>O(A) Coordenador(a) da Disciplina</strong></p>
    <input type="text" name="coordenador_disciplina">
</div>

<button type="submit" class="btn">Salvar</button>
</form>

</body>
</html>