<?php
session_start();
include 'conexao.php';

// Apenas usuários autenticados (ex: SECRETARIA GERAL) podem acessar
if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

$nome_usuario = $_SESSION['usuario']['nome'] ?? 'Usuário';
$foto_usuario = $_SESSION['usuario']['foto'] ?? 'sem-foto.png';

// Carrega alunos do banco
$alunos = [];
$res = $conn->query("SELECT id, nome FROM alunos ORDER BY nome");
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $alunos[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Lançamento de Propinas</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: #f4f6f9;
      margin: 0;
      padding: 0;
    }
    .container {
      max-width: 600px;
      background: white;
      margin: 80px auto;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #003366;
    }
    label {
      display: block;
      margin: 15px 0 5px;
      color: #333;
    }
    select, input[type="text"], input[type="submit"] {
      width: 100%;
      padding: 10px;
      border-radius: 5px;
      border: 1px solid #ccc;
      font-size: 15px;
    }
    input[type="submit"] {
      background: #28a745;
      color: white;
      cursor: pointer;
      margin-top: 20px;
    }
    input[type="submit"]:hover {
      background: #218838;
    }
  </style>
</head>
<body>

<a href="painel_subadmin.php" style="
    display: inline-block;
    margin: 20px;
    padding: 10px 20px;
    background-color: #003366;
    color: white;
    text-decoration: none;
    border-radius: 5px;
    font-weight: bold;
">
  ⬅ Voltar ao Painel
</a>









<div class="container">
  <h2><i class="fas fa-money-bill-wave"></i> Registrar Pagamento de Propina</h2>
  <form action="salvar_propina.php" method="POST">
    
    <!-- Aluno -->
    <label for="aluno_id">Aluno:</label>
    <select name="aluno_id" id="aluno_id" required>
      <option value="">Selecione o aluno</option>
      <?php foreach ($alunos as $aluno): ?>
        <option value="<?= $aluno['id'] ?>"><?= htmlspecialchars($aluno['nome']) ?></option>
      <?php endforeach; ?>
    </select>

    <!-- Mês -->
    <label for="mes_pagamento">Mês de Pagamento:</label>
    <select name="mes_pagamento" id="mes_pagamento" required>
      <option value="">Selecione o mês</option>
      <?php
        $meses = ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho',
                  'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];
        foreach ($meses as $mes) {
            echo "<option value=\"$mes\">$mes</option>";
        }
      ?>
    </select>

    <!-- Valor -->
    <label for="valor">Valor Pago (Kz):</label>
    <select name="valor" id="valor" required>
      <option value="">Selecione o valor</option>
      <?php
        for ($i = 1000; $i <= 100000; $i += 500) {
            echo "<option value=\"$i\">$i Kz</option>";
        }
      ?>
    </select>

    <!-- Data (oculta) -->
    <input type="hidden" name="data_pagamento" value="<?= date('Y-m-d H:i:s') ?>">

    <input type="submit" value="Salvar Pagamento">
  </form>
</div>

</body>
</html>
