<?php
session_start();
include 'conexao.php';

// Restringir o acesso apenas ao Diretor Pedagógico
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

$mensagem = '';
$tipo_mensagem = '';
$ano_lectivo_atual = '2025/2026'; // Defina o ano letivo atual

// Processar a reabertura do trimestre
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $turma_id_selecionada = (int)($_POST['turma_id'] ?? 0);
    $trimestre_selecionado = (int)($_POST['trimestre'] ?? 0);

    if ($turma_id_selecionada > 0 && $trimestre_selecionado > 0) {
        try {
            $conn->begin_transaction();

            // Excluir os registros de fechamento para a turma e trimestre selecionados
            $stmt_delete = $conn->prepare("DELETE FROM fecho_trimestre WHERE turma_id = ? AND ano_lectivo = ? AND trimestre = ?");
            if (!$stmt_delete) {
                throw new Exception("Erro na preparação da exclusão: " . $conn->error);
            }
            $stmt_delete->bind_param("isi", $turma_id_selecionada, $ano_lectivo_atual, $trimestre_selecionado);
            $stmt_delete->execute();
            $rows_affected = $conn->affected_rows;
            $stmt_delete->close();

            $conn->commit();

            if ($rows_affected > 0) {
                $mensagem = "Prazo para o {$trimestre_selecionado}º Trimestre reaberto com sucesso para a turma! Os professores já podem alterar as notas.";
                $tipo_mensagem = 'success';
            } else {
                $mensagem = "Nenhum prazo para o {$trimestre_selecionado}º Trimestre estava fechado para esta turma.";
                $tipo_mensagem = 'info'; // Use 'info' para indicar que não é um erro
            }

        } catch (Exception $e) {
            $conn->rollback();
            $mensagem = "Erro ao reabrir o prazo: " . $e->getMessage();
            $tipo_mensagem = 'error';
        }
    } else {
        $mensagem = "Por favor, selecione uma turma e um trimestre válidos.";
        $tipo_mensagem = 'error';
    }
}

// Buscar turmas para o select com classe e curso
$turmas = $conn->query("SELECT id, nome, classe, curso FROM turmas ORDER BY nome")->fetch_all(MYSQLI_ASSOC);

?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Reabrir Prazo de Notas</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background-color: #f4f7f9; }
        .container { max-width: 600px; margin: auto; padding: 20px; border: 1px solid #e0e6ed; border-radius: 8px; background-color: #ffffff; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #333; margin-bottom: 20px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; color: #555; }
        select, button { width: 100%; padding: 10px; box-sizing: border-box; border-radius: 4px; }
        select { border: 1px solid #ccc; }
        button { background-color: #dc3545; color: white; border: none; cursor: pointer; font-size: 16px; font-weight: bold; }
        button:hover { background-color: #c82333; }
        .alert-message { margin-bottom: 15px; padding: 12px; border-radius: 4px; font-weight: bold; }
        .alert-message.success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .alert-message.error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .alert-message.info { background-color: #cfe2ff; color: #084298; border: 1px solid #b6d4fe; }
        .back-link { display: block; text-align: center; margin-top: 20px; color: #007bff; text-decoration: none; }
        .back-link:hover { text-decoration: underline; }
    </style>
</head>
<body>

<div class="container">
    <h2>Reabrir Prazo de Lançamento</h2>
    <?php if (!empty($mensagem)): ?>
        <div class="alert-message <?= htmlspecialchars($tipo_mensagem) ?>">
            <?= htmlspecialchars($mensagem) ?>
        </div>
    <?php endif; ?>
    <form method="POST">
        <div class="form-group">
            <label for="turma_id">Selecionar Turma:</label>
            <select name="turma_id" id="turma_id" required>
                <option value="">-- Selecione uma turma --</option>
                <?php foreach ($turmas as $turma): ?>
                    <option value="<?= htmlspecialchars($turma['id']) ?>">
                        <?= htmlspecialchars($turma['classe'] . "ª - " . $turma['nome'] . " - " . $turma['curso']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="trimestre">Selecionar Trimestre:</label>
            <select name="trimestre" id="trimestre" required>
                <option value="">-- Selecione um trimestre --</option>
                <option value="1">1º Trimestre</option>
                <option value="2">2º Trimestre</option>
                <option value="3">3º Trimestre</option>
            </select>
        </div>
        <button type="submit">Reabrir Prazo</button>
    </form>
    <a href="painel_direcao.php" class="back-link">Voltar ao Painel</a>
</div>

</body>
</html>