<?php
session_start();
include 'conexao.php';

// Buscar categorias da tabela categorias_financeiras
$categorias_result = $conn->query("SELECT id, nome FROM categorias_financeiras ORDER BY nome");

$data = date('Y-m-d');
$msg = '';

if (isset($_POST['salvar'])) {
    $data = $_POST['data'];
    $categoria_id = $_POST['categoria'];
    $subcategoria_id = $_POST['subcategoria'];
    $descricao = $_POST['descricao'];
    $valor = $_POST['valor'];
    $origem = $_POST['origem'];

    // Buscar os nomes das categorias e subcategorias com base nos IDs
    $stmt_cat = $conn->prepare("SELECT nome FROM categorias_financeiras WHERE id = ?");
    $stmt_cat->bind_param("i", $categoria_id);
    $stmt_cat->execute();
    $stmt_cat->bind_result($nome_categoria);
    $stmt_cat->fetch();
    $stmt_cat->close();

    $stmt_sub = $conn->prepare("SELECT nome FROM subcategorias_financeiras WHERE id = ?");
    $stmt_sub->bind_param("i", $subcategoria_id);
    $stmt_sub->execute();
    $stmt_sub->bind_result($nome_subcategoria);
    $stmt_sub->fetch();
    $stmt_sub->close();
    
    // Inserir na tabela despesas
    $stmt = $conn->prepare("INSERT INTO despesas (data, categoria, subcategoria, descricao, valor, origem) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssdss", $data, $nome_categoria, $nome_subcategoria, $descricao, $valor, $origem);
    $stmt->execute();
    $stmt->close();
    
    // Inserir na tabela movimentos_diarios
    $tipo = 'Saída';
    $descricaoMov = "Despesa - $nome_categoria: $nome_subcategoria";
    
    // Comando SQL ajustado para incluir todas as colunas da sua tabela
    $stmt2 = $conn->prepare("INSERT INTO movimentos_diarios (data, tipo, valor, categoria, subcategoria, descricao, categoria_id, subcategoria_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    
    // Parâmetros ajustados para 'sssdssii' para os novos campos
    $stmt2->bind_param("sssdssii", $data, $tipo, $valor, $nome_categoria, $nome_subcategoria, $descricaoMov, $categoria_id, $subcategoria_id);
    
    $stmt2->execute();
    $stmt2->close();
    
    $msg = "✅ Despesa registrada com sucesso!";
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Registrar Despesa</title>
    <link rel="stylesheet" href="estilo.css">
    <style>
        <?php include 'estilo_financeiro.css'; ?>
    </style>
    <script>
        function carregarSubcategorias() {
            const categoriaId = document.getElementById("categoria").value;
            const subSelect = document.getElementById("subcategoria");

            // Limpa o select e adiciona a mensagem de carregamento
            subSelect.innerHTML = "<option value=''>Carregando...</option>";

            // Verifica se uma categoria válida foi selecionada
            if (categoriaId) {
                fetch("buscar_subcategorias.php?categoria_id=" + categoriaId)
                    .then(response => response.json())
                    .then(data => {
                        subSelect.innerHTML = "";
                        // Adiciona a opção "Selecione" no início da lista
                        const defaultOpt = document.createElement("option");
                        defaultOpt.value = "";
                        defaultOpt.textContent = "-- Selecione --";
                        subSelect.appendChild(defaultOpt);

                        data.forEach(sub => {
                            const opt = document.createElement("option");
                            opt.value = sub.id;
                            opt.textContent = sub.nome;
                            subSelect.appendChild(opt);
                        });
                    })
                    .catch(() => {
                        subSelect.innerHTML = "<option value=''>Erro ao carregar</option>";
                    });
            } else {
                // Se nenhuma categoria for selecionada, limpa o campo e adiciona a mensagem
                subSelect.innerHTML = "<option value=''>-- Selecione uma categoria primeiro --</option>";
            }
        }
    </script>
</head>
<body>

    <div class="barra-lateral">
        <a href="painel_financeiro.php">🏠 Início</a>
        <a href="ver_movimentos.php">➕ Movimento</a>
        <a href="registrar_receita.php">💰 Receita</a>
        <a href="registrar_despesa.php" class="ativo">💸 Despesa</a>
        <a href="relatorio_mensal.php">📊 Resumo</a>
    </div>

    <div class="barra-superior">
        <h2>💸 Registrar Despesa</h2>
    </div>

    <div class="formulario">
        <form method="POST">
            <label>Data:</label>
            <input type="date" name="data" value="<?= $data ?>" required>

            <label>Categoria:</label>
            <select name="categoria" id="categoria" onchange="carregarSubcategorias()" required>
                <option value="">-- Selecione --</option>
                <?php $categorias_result->data_seek(0); // Reseta o ponteiro para o início ?>
                <?php while ($cat = $categorias_result->fetch_assoc()): ?>
                    <option value="<?= $cat['id'] ?>">
                        <?= $cat['nome'] ?>
                    </option>
                <?php endwhile; ?>
            </select>

            <label>Subcategoria:</label>
            <select name="subcategoria" id="subcategoria" required>
                <option value="">-- Selecione uma categoria primeiro --</option>
            </select>

            <label>Descrição:</label>
            <input type="text" name="descricao" placeholder="Ex: Pagamento de energia elétrica" required>

            <label>Valor (Kz):</label>
            <input type="number" step="0.01" name="valor" required>

            <label>Origem / Observações:</label>
            <textarea name="origem" rows="3" placeholder="Ex: Conta de julho, ENDE"></textarea>

            <button type="submit" name="salvar">💾 Salvar</button>
            <button type="button" onclick="location.href='ver_despesas.php'">📂 Ver Registros</button>
            <button type="button" onclick="location.href='painel_financeiro.php'">🏠 Início</button>

            <?php if ($msg) echo "<div class='mensagem'>$msg</div>"; ?>
        </form>
    </div>
</body>
</html>