<?php
session_start();
include 'conexao.php';

$data = date('Y-m-d');
$msg = '';

if (isset($_POST['salvar'])) {
    $data = $_POST['data'];
    $categoria = $_POST['categoria'];
    $subcategoria = $_POST['subcategoria'];
    $descricao = $_POST['descricao'];
    $valor = $_POST['valor'];
    $origem = $_POST['origem'];

    // 1. Inserir na tabela receitas
    $stmt = $conn->prepare("INSERT INTO receitas (data, categoria, subcategoria, descricao, valor, origem) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssdss", $data, $categoria, $subcategoria, $descricao, $valor, $origem);
    $stmt->execute();

    // 2. Inserir na tabela movimentos_diarios
    $tipo = 'Entrada';
    $descricaoMov = "Receita - $categoria: $subcategoria";

    $stmt2 = $conn->prepare("INSERT INTO movimentos_diarios (data, tipo, valor, categoria, subcategoria, descricao) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt2->bind_param("ssdsss", $data, $tipo, $valor, $categoria, $subcategoria, $descricaoMov);
    $stmt2->execute();

    $msg = "✅ Receita registrada com sucesso!";
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Registrar Receita</title>
  <link rel="stylesheet" href="estilo.css">
  <style>
    <?php include 'estilo_financeiro.css'; ?>
  </style>
</head>
<body>

<div class="barra-lateral">
  <a href="painel_financeiro.php">🏠 Início</a>
  <a href="ver_movimentos.php">➕ Movimento</a>
  <a href="registrar_receita.php" class="ativo">💰 Receita</a>
  <a href="registrar_despesa.php">💸 Despesa</a>
  <a href="relatorio_mensal.php">📊 Resumo</a>
</div>

<div class="barra-superior">
  <h2>💰 Registrar Receita</h2>
</div>

<div class="formulario">
  <form method="POST">
    <label>Data:</label>
    <input type="date" name="data" value="<?= $data ?>" required>

    <label>Categoria:</label>
    <select name="categoria" required>
      <option value="1.1 - RECEITAS OPERACIONAIS">1.1 - RECEITAS OPERACIONAIS</option>
      <option value="1.2 - RECEITAS DIVERSAS">1.2 - RECEITAS DIVERSAS</option>
    </select>

    <label>Subcategoria:</label>
    <select name="subcategoria" required>
      <optgroup label="1.1 - RECEITAS OPERACIONAIS">
        <option value="1.1.1 - Comparticipações">1.1.1 - Comparticipações</option>
        <option value="1.1.2 - Donativos">1.1.2 - Donativos</option>
        <option value="1.1.3 - Venda de Batas">1.1.3 - Venda de Batas</option>
        <option value="1.1.4 - Reprografia">1.1.4 - Reprografia</option>
        <option value="1.1.5 - Venda de Folhas de Prova">1.1.5 - Venda de Folhas de Prova</option>
        <option value="1.1.6 - Cantinas">1.1.6 - Cantinas</option>
        <option value="1.1.7 - Justificativo de Faltas">1.1.7 - Justificativo de Faltas</option>
        <option value="1.1.8 - Certificado/Declarações">1.1.8 - Certificado/Declarações</option>
        <option value="1.1.9">1.1.9</option>
      </optgroup>
      <optgroup label="1.2 - RECEITAS DIVERSAS">
      
      </optgroup>
    </select>

    <label>Descrição:</label>
    <input type="text" name="descricao" placeholder="Ex: Receita de propina do aluno João" required>

    <label>Valor (Kz):</label>
    <input type="number" step="0.01" name="valor" required>

    <label>Origem / Observações:</label>
    <textarea name="origem" rows="3" placeholder="Ex: Pagamento em dinheiro, João Silva"></textarea>

    <button type="submit" name="salvar">💾 Salvar</button>
    <button type="button" onclick="location.href='ver_receitas.php'">📂 Ver Registros</button>
    <button type="button" onclick="location.href='painel_financeiro.php'">🏠 Início</button>

    <?php if ($msg) echo "<div class='mensagem'>$msg</div>"; ?>
  </form>
</div>

</body>
</html>
