<?php
include 'conexao.php';
session_start();

if (!isset($_GET['aluno_id']) || !isset($_GET['turma_id'])) {
    die("ID do aluno ou da turma não fornecido.");
}

$aluno_id = intval($_GET['aluno_id']);
$turma_id = intval($_GET['turma_id']);

try {
    // Iniciar uma transação para garantir que as operações sejam atômicas
    $conn->begin_transaction();

    // 1. Remover dados relacionados na tabela 'matriculas'
    // Esta linha está correta, pois a coluna é 'aluno_id'
    $stmt_matriculas = $conn->prepare("DELETE FROM matriculas WHERE aluno_id = ?");
    $stmt_matriculas->bind_param("i", $aluno_id);
    $stmt_matriculas->execute();
    $stmt_matriculas->close();
    
    // 2. Remover o aluno da tabela 'alunos' (a tabela "pai")
    // Conforme sua informação, a chave primária da tabela 'alunos' é 'id'
    $stmt_alunos = $conn->prepare("DELETE FROM alunos WHERE id = ?");
    $stmt_alunos->bind_param("i", $aluno_id);
    $stmt_alunos->execute();
    $stmt_alunos->close();

    // 3. Reorganizar a numeração dos alunos restantes na turma
    $stmt_select = $conn->prepare("SELECT id FROM alunos WHERE turma_id = ? ORDER BY nome ASC");
    $stmt_select->bind_param("i", $turma_id);
    $stmt_select->execute();
    $alunos_restantes = $stmt_select->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt_select->close();

    $stmt_update = $conn->prepare("UPDATE alunos SET numero = ? WHERE id = ?");
    $novo_numero = 1; // Começa a re-enumeração do número 1
    foreach ($alunos_restantes as $aluno_restante) {
        $stmt_update->bind_param("ii", $novo_numero, $aluno_restante['id']);
        $stmt_update->execute();
        $novo_numero++;
    }
    $stmt_update->close();

    // Comitar a transação
    $conn->commit();

    // Redirecionar de volta para a lista atualizada
    header("Location: lista_alunos_turma.php?turma_id=" . $turma_id);
    exit();

} catch (mysqli_sql_exception $e) {
    // Em caso de erro, reverter as alterações
    $conn->rollback();
    die("Erro ao remover o aluno e reorganizar a lista: " . $e->getMessage());
}
?>