<?php
session_start();
include 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo "Método inválido.";
    exit;
}

$id = intval($_POST['id']);

// Receber campos
$nome         = trim($_POST['nome'] ?? '');
$sala         = trim($_POST['sala'] ?? '');
$municipio    = trim($_POST['municipio'] ?? '');
$provincia    = trim($_POST['provincia'] ?? '');
$nome_pai     = trim($_POST['nome_pai'] ?? '');
$nome_mae     = trim($_POST['nome_mae'] ?? '');
$data_nasc    = $_POST['data_nascimento'] ?? null;
$naturalidade = trim($_POST['naturalidade'] ?? '');
$bi_numero    = trim($_POST['bi_numero'] ?? '');
$bi_emitido   = trim($_POST['bi_emitido_em'] ?? '');
$bi_data      = $_POST['bi_data_emissao'] ?? null;
$curso        = trim($_POST['curso'] ?? '');
$idade        = trim($_POST['idade'] ?? '');
$ano_letivo   = trim($_POST['ano_letivo'] ?? '');
$genero       = trim($_POST['genero'] ?? '');

// Foto
$foto_nome = null;
if (!empty($_FILES['foto']['name'])) {
    $extensao = strtolower(pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION));
    $permitidas = ['jpg', 'jpeg', 'png', 'gif'];

    if (in_array($extensao, $permitidas)) {
        $foto_nome = 'aluno_' . $id . '_' . time() . '.' . $extensao;
        $destino = __DIR__ . '/fotos/' . $foto_nome;
        if (!move_uploaded_file($_FILES['foto']['tmp_name'], $destino)) {
            echo "Erro ao fazer upload da foto.";
            exit;
        }
    } else {
        echo "Formato de imagem inválido.";
        exit;
    }
} else {
    // Mantém foto antiga
    $sql_foto = $conn->prepare("SELECT foto FROM alunos WHERE id = ?");
    $sql_foto->bind_param("i", $id);
    $sql_foto->execute();
    $sql_foto->bind_result($foto_atual);
    $sql_foto->fetch();
    $sql_foto->close();
    $foto_nome = $foto_atual;
}

// Atualiza aluno
$sql = "UPDATE alunos SET 
            nome = ?, 
            sala = ?, 
            municipio = ?, 
            provincia = ?, 
            nome_pai = ?, 
            nome_mae = ?, 
            data_nascimento = ?, 
            naturalidade = ?, 
            bi_numero = ?, 
            bi_emitido_em = ?, 
            bi_data_emissao = ?, 
            curso = ?, 
            idade = ?, 
            ano_letivo = ?, 
            genero = ?, 
            foto = ?
        WHERE id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param(
    "ssssssssssssisssi",
    $nome,
    $sala,
    $municipio,
    $provincia,
    $nome_pai,
    $nome_mae,
    $data_nasc,
    $naturalidade,
    $bi_numero,
    $bi_emitido,
    $bi_data,
    $curso,
    $idade,
    $ano_letivo,
    $genero,
    $foto_nome,
    $id
);

if ($stmt->execute()) {
    $_SESSION['msg_sucesso'] = "Dados do aluno atualizados com sucesso!";
    header("Location: editar_aluno.php?id=" . $id);
    exit;
} else {
    echo "Erro ao atualizar: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>
