<?php
session_start();
include 'conexao.php';

header('Content-Type: application/json');

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        $response['message'] = 'Erro ao decodificar dados JSON.';
        echo json_encode($response);
        exit;
    }

    $containerId = $data['container_id'] ?? null;
    $horarioJson = json_encode($data['horario']);

    if (!$containerId || !$horarioJson) {
        $response['message'] = 'Dados incompletos recebidos.';
        echo json_encode($response);
        exit;
    }

    // A partir do ID do contêiner, determine o tipo e o ID correspondente
    $idParts = explode('-', $containerId);
    $tipo = $idParts[0];
    $nome = urldecode(implode('-', array_slice($idParts, 1)));
    
    $turmaId = null;
    $professorId = null;

    if ($tipo === 'turma') {
        // Encontra o turma_id pelo nome da turma
        $stmt = $conn->prepare("SELECT id FROM turmas WHERE CONCAT(classe, ' - ', nome, ' - ', curso, ' - ', turno, ' - Sala ', sala) = ?");
        $stmt->bind_param("s", $nome);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($turma = $result->fetch_assoc()) {
            $turmaId = $turma['id'];
        }
        $stmt->close();
    } elseif ($tipo === 'prof') {
        // Encontra o professor_id pelo nome do professor
        $stmt = $conn->prepare("SELECT id FROM usuarios WHERE nome = ? AND tipo_usuario = 'professor'");
        $stmt->bind_param("s", $nome);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($professor = $result->fetch_assoc()) {
            $professorId = $professor['id'];
        }
        $stmt->close();
    } else {
        $response['message'] = 'Tipo de horário inválido.';
        echo json_encode($response);
        exit;
    }

    if (!$turmaId && !$professorId) {
        $response['message'] = 'Não foi possível encontrar a turma ou o professor correspondente.';
        echo json_encode($response);
        exit;
    }

    // Verificar se já existe um registro para este horário
    $checkStmt = null;
    if ($tipo === 'turma') {
        $checkStmt = $conn->prepare("SELECT id FROM horarios_editados WHERE turma_id = ? AND tipo = 'turma'");
        $checkStmt->bind_param("i", $turmaId);
    } else {
        $checkStmt = $conn->prepare("SELECT id FROM horarios_editados WHERE professor_id = ? AND tipo = 'professor'");
        $checkStmt->bind_param("i", $professorId);
    }
    
    $checkStmt->execute();
    $existingRecord = $checkStmt->get_result()->fetch_assoc();
    $checkStmt->close();

    if ($existingRecord) {
        // Atualiza o registro existente
        $updateStmt = $conn->prepare("UPDATE horarios_editados SET dados = ?, data_edicao = NOW() WHERE id = ?");
        $updateStmt->bind_param("si", $horarioJson, $existingRecord['id']);
        if ($updateStmt->execute()) {
            $response['success'] = true;
            $response['message'] = 'Horário atualizado com sucesso!';
        } else {
            $response['message'] = 'Erro ao atualizar horário: ' . $updateStmt->error;
        }
        $updateStmt->close();
    } else {
        // Insere um novo registro
        $insertStmt = $conn->prepare("INSERT INTO horarios_editados (turma_id, professor_id, tipo, dados) VALUES (?, ?, ?, ?)");
        if ($tipo === 'turma') {
            $insertStmt->bind_param("iiss", $turmaId, $professorId, $tipo, $horarioJson);
        } else {
            $insertStmt->bind_param("iiss", $turmaId, $professorId, $tipo, $horarioJson);
        }
        
        if ($insertStmt->execute()) {
            $response['success'] = true;
            $response['message'] = 'Horário salvo com sucesso!';
        } else {
            $response['message'] = 'Erro ao salvar novo horário: ' . $insertStmt->error;
        }
        $insertStmt->close();
    }

} else {
    $response['message'] = 'Método de requisição inválido.';
}

echo json_encode($response);
?>