<?php
// O session_start() e ini_set DEVERIAM estar centralizados no conexao.php.
// Mantemos a verificação aqui POR ENQUANTO, mas a melhor prática é no include 'conexao.php'.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include 'conexao.php'; // Assume que conexao.php define $conn

// ====================================================================
// 1. VERIFICAÇÃO DE SEGURANÇA E ACESSO
// ====================================================================

// Verifica se o usuário é professor
$perfil = $_SESSION['usuario']['perfil'] ?? '';
if (strtoupper(trim($perfil)) !== 'PROFESSOR') {
    // Redireciona para o login se não for Professor
    header('Location: login.php');
    exit;
}

// Apenas aceitar requisições POST do formulário
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    // Este erro NÃO deve acontecer se o formulário HTML estiver correto (method="POST")
    die("Erro: Requisição inválida. O acesso direto a este script não é permitido.");
}

// ====================================================================
// 2. VALIDAÇÃO DOS DADOS PRINCIPAIS
// ====================================================================

$aluno_ids       = $_POST['aluno_id'] ?? [];
$disciplina_id   = (int)($_POST['disciplina_id'] ?? 0);
$turma_id        = (int)($_POST['turma_id'] ?? 0);
$trimestre       = (int)($_POST['trimestre'] ?? 0);
$ano_lectivo     = '2025/2026';

if (empty($aluno_ids) || $disciplina_id <= 0 || $turma_id <= 0 || $trimestre <= 0) {
    // Redireciona com mensagem de erro se os dados essenciais estiverem ausentes
    $_SESSION['mensagem_erro'] = "Erro ao salvar: dados do formulário incompletos.";
    header("Location: mini_pauta_professor1.php"); // Redireciona para a página de pautas
    exit;
}

// Inicia transação para garantir a integridade dos dados
$conn->begin_transaction();

try {
    // ====================================================================
    // 3. PREPARAÇÃO DA QUERY DE SALVAMENTO (UPSERT)
    // ====================================================================

    $sql_upsert = "
        REPLACE INTO notas (
            aluno_id, turma_id, disciplina_id, ano_lectivo, trimestre, classe,
            mac, npp, npt, mt1, mt2, mt3,
            mfd, mf, neo, nee, mec, exame, nota_final
        ) VALUES (
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
        )
    ";
    $stmt_upsert = $conn->prepare($sql_upsert);
    if (!$stmt_upsert) throw new Exception("Erro ao preparar statement: " . $conn->error);

    // Obtém a classe da turma (necessário para a tabela notas)
    $classe = '';
    $sql_classe = "SELECT classe FROM turmas WHERE id = ?";
    $stmt_classe = $conn->prepare($sql_classe);
    $stmt_classe->bind_param("i", $turma_id);
    $stmt_classe->execute();
    $res = $stmt_classe->get_result();
    if ($res->num_rows > 0) $classe = $res->fetch_assoc()['classe'];
    $stmt_classe->close();

    // ====================================================================
    // 4. PROCESSAMENTO DAS NOTAS POR ALUNO
    // ====================================================================

    foreach ($aluno_ids as $aluno_id) {
        $aluno_id = (int)$aluno_id;

        // Notas do trimestre atual
        $mac = (float)($_POST["mac_{$trimestre}_{$aluno_id}"] ?? 0);
        $npp = (float)($_POST["npp_{$trimestre}_{$aluno_id}"] ?? 0);
        $npt = (float)($_POST["npt_{$trimestre}_{$aluno_id}"] ?? 0);
        $mt_trimestre = ($mac + $npp + $npt) / 3;

        // Variáveis de notas finais (inicializadas com os valores do BD)
        $mt1 = 0; $mt2 = 0; $mt3 = 0;
        $mfd = 0; $mf = 0; $neo = 0; $nee = 0; $mec = 0; $exame = 0; $nota_final = 0;

        // Busca todas as notas existentes para este aluno/disciplina (necessário para MFD)
        $sql_busca = "SELECT trimestre, mt, mfd, mf, neo, nee, mec, exame, nota_final FROM notas WHERE aluno_id=? AND disciplina_id=? AND turma_id=? AND ano_lectivo=?";
        $stmt_busca = $conn->prepare($sql_busca);
        $stmt_busca->bind_param("iiis", $aluno_id, $disciplina_id, $turma_id, $ano_lectivo);
        $stmt_busca->execute();
        $res_busca = $stmt_busca->get_result();
        
        while ($row = $res_busca->fetch_assoc()) {
            $t = (int)$row['trimestre'];
            if ($t === 1) $mt1 = (float)($row['mt'] ?? 0);
            if ($t === 2) $mt2 = (float)($row['mt'] ?? 0);
            // O MT3 será atualizado abaixo
            
            // As médias finais são armazenadas no registro do 3º trimestre
            if ($t === 3) { 
                $mt3 = (float)($row['mt'] ?? 0);
                $mfd = (float)($row['mfd'] ?? 0);
                $mf  = (float)($row['mf'] ?? 0);
                $neo = (float)($row['neo'] ?? 0);
                $nee = (float)($row['nee'] ?? 0);
                $mec = (float)($row['mec'] ?? 0);
                $exame = (float)($row['exame'] ?? 0);
                $nota_final = (float)($row['nota_final'] ?? 0);
            }
        }
        $stmt_busca->close();

        // 5. ATUALIZAÇÃO E RECÁLCULO DAS MÉDIAS
        
        // Atualiza o MT do trimestre atual com o valor recém-calculado
        if ($trimestre === 1) $mt1 = $mt_trimestre;
        if ($trimestre === 2) $mt2 = $mt_trimestre;
        if ($trimestre === 3) $mt3 = $mt_trimestre;

        // Se for 3º trimestre, recalcula MFD e MF
        if ($trimestre === 3) {
            $mfd = ($mt1 + $mt2 + $mt3) / 3; // Média Final da Disciplina (sem exame)
            
            $neo = (float)($_POST["neo_{$aluno_id}"] ?? $neo); // Pega NEO do POST ou mantém o anterior
            $nee = (float)($_POST["nee_{$aluno_id}"] ?? $nee); // Pega NEE do POST ou mantém o anterior

            if ($neo > 0 && $nee > 0) $mec = ($neo + $nee) / 2;
            else if ($nee > 0) $mec = $nee; // Se só tem NEE (ou MEC anterior)
            else $mec = 0;
            
            // Média Final (MF) com ponderação Angolana (60% MFD + 40% MEC)
            $mf = ($mfd * 0.6) + ($mec * 0.4);
        }

        // ====================================================================
        // 6. EXECUÇÃO DO REPLACE (19 campos)
        // ====================================================================

        // Os valores MAC, NPP, NPT devem ser os do trimestre ATUAL
        // Os valores MT1, MT2, MT3, MFD, MF, NEO, NEE, MEC, EXAME, NOTA_FINAL devem ser os RECALCULADOS/BUSCADOS
        
        $types = "iiisiisdddddddddddd";
        $params = [
            $aluno_id, $turma_id, $disciplina_id, $ano_lectivo, $trimestre, $classe,
            $mac, $npp, $npt,
            $mt1, $mt2, $mt3,
            $mfd, $mf, $neo, $nee, $mec, $exame, $nota_final
        ];
        
        // Substituímos os placeholders (?) com os parâmetros
        $stmt_upsert->bind_param($types, ...$params);
        $stmt_upsert->execute();
    }

    // Finaliza a transação
    $conn->commit();
    $stmt_upsert->close();
    
    // Mensagem de sucesso para o utilizador
    $_SESSION['mensagem_sucesso'] = "Notas salvas com sucesso!";

    // Redireciona de volta para a pauta (mantendo os filtros)
    header("Location: mini_pauta_professor1.php?turma_id={$turma_id}&disciplina_id={$disciplina_id}&trimestre={$trimestre}");
    exit;

} catch (Exception $e) {
    $conn->rollback();
    $_SESSION['mensagem_erro'] = "Erro interno ao salvar notas: " . $e->getMessage();
    
    // Redireciona de volta para a página de pautas
    header("Location: mini_pauta_professor1.php?turma_id={$turma_id}&disciplina_id={$disciplina_id}&trimestre={$trimestre}");
    exit;
}

$conn->close();
?>