<?php
session_start();
include 'conexao.php';

// Verifica se a requisição é um POST e se os dados necessários estão presentes
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['aluno_id'], $_POST['observacoes'])) {
    
    $aluno_id = intval($_POST['aluno_id']);
    $observacoes = $_POST['observacoes'];
    $turma_id = $_POST['turma_id'] ?? null;

    // Prepara a consulta SQL para atualizar a observação
    $sql = "UPDATE alunos SET observacoes = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $observacoes, $aluno_id);

    if ($stmt->execute()) {
        // Redireciona de volta para a mesma página com a turma selecionada
        header("Location: lista_alunos.php?turma_id=" . $turma_id);
        exit;
    } else {
        echo "Erro ao atualizar a observação: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();

} else {
    // Se não for uma requisição POST válida, redireciona para a página inicial
    header("Location: index.php");
    exit;
}
?>