<?php
include 'conexao.php';
session_start();

// Redireciona se não for uma requisição POST ou se os dados essenciais estiverem faltando
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['status']) || !isset($_POST['turma_id_origem'])) {
    header("Location: ver_lista_turma.php");
    exit;
}

$turma_id = filter_input(INPUT_POST, 'turma_id_origem', FILTER_VALIDATE_INT);

// O array 'status' contém [matricula_id] => [novo_status]
$novos_status = $_POST['status'];

$sucesso = true;
$mensagem = '';

// Prepara a consulta de atualização
// WHERE id = ? é o ID da MATRÍCULA
$stmt = $conn->prepare("UPDATE matriculas SET status = ? WHERE id = ?");

if ($stmt) {
    // Itera sobre o array de status. A chave é o matricula_id e o valor é o novo status.
    foreach ($novos_status as $matricula_id => $novo_status) {
        $matricula_id_int = intval($matricula_id);
        
        // Verifica se o status é um valor permitido (para segurança)
        $status_valido = in_array($novo_status, ['Activo', 'Desistente', 'Transferido', 'Concluido']);

        if ($matricula_id_int > 0 && $status_valido) {
            $stmt->bind_param("si", $novo_status, $matricula_id_int);
            if (!$stmt->execute()) {
                $sucesso = false;
                $mensagem .= "Erro ao atualizar matrícula ID $matricula_id: " . $stmt->error . "<br>";
            }
        }
    }
    $stmt->close();
} else {
    $sucesso = false;
    $mensagem = "Erro na preparação da consulta: " . $conn->error;
}

$conn->close();

// Redireciona de volta para a lista, mantendo os filtros
$url_redirecionar = "ver_lista_turma.php?turma_id=" . $turma_id;

if ($sucesso) {
    // Redireciona com uma mensagem de sucesso (opcional: usar sessão para feedback)
    $_SESSION['feedback'] = ['tipo' => 'success', 'texto' => 'Status(es) atualizado(s) com sucesso.'];
} else {
    $_SESSION['feedback'] = ['tipo' => 'error', 'texto' => 'Erro ao salvar o(s) status: ' . $mensagem];
}

header("Location: $url_redirecionar");
exit;
?>