<?php
include 'conexao.php';

// Busca os alunos
$alunos = [];
$res = $conn->query("SELECT id, nome FROM alunos ORDER BY nome");
while ($row = $res->fetch_assoc()) {
    $alunos[] = $row;
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Gerar Documentos</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f9f9f9;
            padding: 50px;
            text-align: center;
        }
        select {
            padding: 10px;
            margin: 15px;
            width: 300px;
            font-size: 16px;
        }
        label {
            font-weight: bold;
        }
        h2 {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

    <h2>Selecionar Aluno e Documento</h2>

    <!-- ComboBox de Alunos -->
    <label for="aluno">Aluno:</label><br>
    <select id="aluno" onchange="mostrarOpcoes()">
        <option value="">-- Escolha um aluno --</option>
        <?php foreach ($alunos as $a): ?>
            <option value="<?= $a['id'] ?>"><?= htmlspecialchars($a['nome']) ?></option>
        <?php endforeach; ?>
    </select>

    <!-- ComboBox de Opções de Documento -->
    <div id="opcoes" style="display: none;">
        <label for="documento">Documento:</label><br>
        <select id="documento" onchange="redirecionar()">
            <option value="">-- Escolha um documento --</option>
            <option value="termo">Gerar Termo</option>
            <option value="certificado">Gerar Certificado</option>
            <option value="declaracao">Gerar Declaração</option>
            <option value="boletim">Ver Boletim</option>
        </select>
    </div>

    <script>
        function mostrarOpcoes() {
            const aluno = document.getElementById('aluno').value;
            const opcoes = document.getElementById('opcoes');
            opcoes.style.display = aluno !== '' ? 'block' : 'none';
        }

        function redirecionar() {
            const alunoId = document.getElementById('aluno').value;
            const tipo = document.getElementById('documento').value;

            if (!alunoId || !tipo) return;

            let url = '';
            switch (tipo) {
                case 'termo':
                    url = 'gerar_termo.php?aluno_id=' + alunoId;
                    break;
                case 'certificado':
                    url = 'gerar_certificado.php?aluno_id=' + alunoId;
                    break;
                case 'declaracao':
                    url = 'gerar_declaracao.php?aluno_id=' + alunoId;
                    break;
                case 'boletim':
                    url = 'ver_boletim_aluno.php?aluno_id=' + alunoId;
                    break;
            }

            if (url) {
                window.open(url, '_blank'); // Abre em nova aba
            }
        }
    </script>

</body>
</html>
