<?php
session_start();
include 'conexao.php';

// Verificar se o usuário tem permissão
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

// Buscar turmas com mais detalhes
$turmas = $conn->query("
    SELECT id, classe, nome, curso, turno, ano
    FROM turmas
    ORDER BY classe, nome, curso, turno, ano
")->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Selecionar Turma</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #e0e0e0;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    .container {
      background: #fff;
      padding: 40px;
      border-radius: 12px;
      box-shadow: 0 0 15px rgba(0,0,0,0.15);
      text-align: center;
      width: 100%;
      max-width: 450px;
    }

    h2 {
      margin-bottom: 20px;
      color: #333;
    }

    select {
      width: 100%;
      padding: 10px;
      font-size: 16px;
      margin-bottom: 20px;
      border-radius: 6px;
      border: 1px solid #ccc;
    }

    button {
      background-color: #1976D2;
      color: white;
      padding: 10px 20px;
      border: none;
      border-radius: 6px;
      font-size: 16px;
      cursor: pointer;
      transition: background 0.3s;
    }

    button:hover {
      background-color: #125ea8;
    }

    .back-btn {
      display: inline-block;
      margin-top: 15px;
      color: #555;
      text-decoration: none;
      font-size: 14px;
    }

    .back-btn i {
      margin-right: 6px;
    }
  </style>
</head>
<body>

<div class="container">
  <h2><i class="fa-solid fa-chalkboard-user"></i> Selecionar Turma</h2>

  <form action="pauta_final.php" method="get">
    <select name="turma_id" required>
      <option value="">-- Escolher Turma --</option>
      <?php foreach ($turmas as $t): ?>
        <option value="<?= htmlspecialchars($t['id']) ?>">
          <?= htmlspecialchars("{$t['classe']} - {$t['nome']} - {$t['curso']} - {$t['turno']} - {$t['ano']}") ?>
        </option>
      <?php endforeach; ?>
    </select>

    <button type="submit"><i class="fa-solid fa-eye"></i> Ver Pauta</button>
  </form>

  <a class="back-btn" href="painel_subpedagogico.php"><i class="fa-solid fa-arrow-left"></i> Voltar ao Painel</a>
</div>

</body>
</html>
