<?php
// Inclua a conexão com o banco de dados
// A senha e usuário do banco de dados podem ser diferentes na hospedagem web
include 'conexao.php';

// Verifique se o ID e o token foram passados na URL
if (!isset($_GET['id']) || !isset($_GET['token'])) {
    die("Erro: Dados de validação incompletos.");
}

$aluno_id = intval($_GET['id']);
$validacao_token = $_GET['token'];

// Prepare a consulta para buscar o aluno com o ID e token correspondentes
$stmt = $conn->prepare("SELECT nome, curso, data_conclusao FROM alunos WHERE id = ? AND validacao_token = ?");
$stmt->bind_param("is", $aluno_id, $validacao_token);
$stmt->execute();
$result = $stmt->get_result();

?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Validação de Certificado</title>
    <style>
        body { font-family: Arial, sans-serif; text-align: center; padding: 50px; }
        .success { color: green; border: 1px solid green; padding: 20px; border-radius: 8px; max-width: 600px; margin: auto; }
        .error { color: red; border: 1px solid red; padding: 20px; border-radius: 8px; max-width: 600px; margin: auto; }
        h1, h2 { margin-top: 0; }
    </style>
</head>
<body>

<?php
if ($result->num_rows > 0) {
    $dados_aluno = $result->fetch_assoc();
    // Certificado válido
    echo "<div class='success'>";
    echo "<h1>Certificado Autêntico!</h1>";
    echo "<p>O certificado pertence a:</p>";
    echo "<h2>" . htmlspecialchars($dados_aluno['nome']) . "</h2>";
    echo "<p><strong>Curso:</strong> " . htmlspecialchars($dados_aluno['curso']) . "</p>";
    echo "<p><strong>Data de Conclusão:</strong> " . htmlspecialchars($dados_aluno['data_conclusao']) . "</p>";
    echo "</div>";
} else {
    // Certificado inválido
    echo "<div class='error'>";
    echo "<h1>Certificado Inválido ou Falsificado</h1>";
    echo "<p>Os dados de validação não correspondem a um certificado válido em nosso sistema.</p>";
    echo "</div>";
}
$stmt->close();
$conn->close();
?>

</body>
</html>