<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
include 'conexao.php';

// Impede acesso direto via GET
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: login.php");
    exit;
}

// Sanitiza e valida entrada
$id_funcionario = trim($_POST['usuario'] ?? '');
$senha          = trim($_POST['senha'] ?? '');

if (empty($id_funcionario) || empty($senha)) {
    $_SESSION['erro_login'] = "Por favor, preencha todos os campos.";
    header("Location: login.php");
    exit;
}

if (!ctype_alnum($id_funcionario)) {
    $_SESSION['erro_login'] = "Usuário inválido.";
    header("Location: login.php");
    exit;
}

// Busca o usuário pelo id_funcionario
$sql = "SELECT * FROM usuarios WHERE id_funcionario = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $id_funcionario);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $usuario = $result->fetch_assoc();

    // Verifica a senha com password_verify
    if (password_verify($senha, $usuario['senha'])) {
        // Salva os dados principais do usuário na sessão
        $_SESSION['usuario'] = [
            'id'             => $usuario['id'],
            'nome'           => $usuario['nome'] ?? 'Usuário',
            'perfil'         => $usuario['perfil'] ?? '',
            'id_funcionario' => $usuario['id_funcionario'],
            'foto'           => $usuario['foto'] ?? 'sem-foto.png'
        ];

        // Redireciona com base no perfil
        $perfil = strtoupper($_SESSION['usuario']['perfil']);

        switch ($perfil) {
            case 'ADMINISTRADOR':
                header("Location: painel.php");
                break;
            case 'PROFESSOR':
                header("Location: painel_professor1.php");
                break;
            case 'SUBDIRECÇÃO ADMINISTRATIVA':
                header("Location: painel_subadmin.php");
                break;
            case 'SUBDIRECÇÃO PEDAGÓGICA':
                header("Location: painel_subpedagogico.php");
                break;
            case 'SECRETARIA GERAL':
                header("Location: painel_secretaria_geral.php");
                break;
            case 'SECRETARIA PEDAGÓGICA':
                header("Location: painel_secpedagogica.php");
                break;
            case 'COORDENAÇÃO DE CURSO':
                header("Location: painel_coordcurso.php");
                break;
            default:
                $_SESSION['erro_login'] = "Perfil desconhecido.";
                header("Location: login.php");
                break;
        }

        exit;
    } else {
        $_SESSION['erro_login'] = "Senha incorreta.";
        header("Location: login.php");
        exit;
    }
} else {
    $_SESSION['erro_login'] = "Usuário não encontrado.";
    header("Location: login.php");
    exit;
}
?>
