<?php
session_start();
include 'conexao.php';

// FILTRO POR DATA
$data_inicial = $_GET['data_inicial'] ?? '';
$data_final = $_GET['data_final'] ?? '';

// QUERY BASE
$sql = "SELECT * FROM movimentos_diarios";
$filtros = [];

if (!empty($data_inicial) && !empty($data_final)) {
    $sql .= " WHERE data BETWEEN ? AND ?";
    $filtros[] = $data_inicial;
    $filtros[] = $data_final;
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", ...$filtros);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $conn->query($sql . " ORDER BY data DESC");
}

// CÁLCULOS
$total_entradas = $conn->query("SELECT SUM(valor) AS total FROM movimentos_diarios WHERE tipo='Entrada'")->fetch_assoc()['total'] ?? 0;
$total_saidas = $conn->query("SELECT SUM(valor) AS total FROM movimentos_diarios WHERE tipo='Saída'")->fetch_assoc()['total'] ?? 0;
$saldo = $total_entradas - $total_saidas;
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Movimentos Diários - SISMAG</title>
    <link rel="stylesheet" href="estilo.css">
    <style>
        body { margin: 0; font-family: Arial; }
        .barra-superior {
            background-color: #007bff;
            padding: 15px;
            color: white;
            position: fixed;
            top: 0;
            left: 220px;
            right: 0;
        }
        .barra-lateral {
            width: 220px;
            height: 100vh;
            background-color: #1a1a1a;
            color: white;
            position: fixed;
            top: 0;
            left: 0;
            padding-top: 60px;
        }
        .barra-lateral a {
            display: block;
            padding: 15px;
            color: white;
            text-decoration: none;
            border-bottom: 1px solid #333;
        }
        .barra-lateral a:hover {
            background-color: #007bff;
        }
        .conteudo {
            margin-left: 240px;
            margin-top: 80px;
            padding: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
        }
        th, td {
            padding: 8px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #f1f1f1;
        }
        .resumo {
            margin-top: 20px;
            font-weight: bold;
        }
        .filtro {
            background: white;
            padding: 15px;
            margin-bottom: 15px;
            border-radius: 6px;
        }
        input[type="date"] {
            padding: 6px;
            margin-right: 10px;
        }
        button {
            padding: 6px 12px;
            background-color: #007bff;
            border: none;
            color: white;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover { background-color: #0056b3; }
    </style>
</head>
<body>

<div class="barra-lateral">
    <a href="painel_financeiro.php">🏠 Início</a>
    <a href="registrar_movimento.php">➕ Registrar Movimento</a>
    <a href="relatorio_mensal.php">📊 Resumo Mensal</a>
    <a href="relatorio_detalhado.php">📋 Detalhado</a>
    
</div>

<div class="barra-superior">
    <h2>📂 Movimentos Diários</h2>
</div>

<div class="conteudo">

    <form class="filtro" method="GET">
        <label>De:</label>
        <input type="date" name="data_inicial" value="<?= $data_inicial ?>">
        <label>Até:</label>
        <input type="date" name="data_final" value="<?= $data_final ?>">
        <button type="submit">🔍 Filtrar</button>
        <button type="button" onclick="window.location='ver_movimentos.php'">🔄 Limpar</button>
    </form>

    <table>
        <thead>
            <tr>
                <th>Data</th>
                <th>Tipo</th>
                <th>Valor (Kz)</th>
                <th>Categoria</th>
                <th>Descrição</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($linha = $result->fetch_assoc()): ?>
            <tr>
                <td><?= date('d/m/Y', strtotime($linha['data'])) ?></td>
                <td><?= $linha['tipo'] ?></td>
                <td><?= number_format($linha['valor'], 2, ',', '.') ?></td>
                <td><?= $linha['categoria'] ?></td>
                <td><?= $linha['descricao'] ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

    <div class="resumo">
        <p>💰 Total de Entradas: <strong><?= number_format($total_entradas, 2, ',', '.') ?> Kz</strong></p>
        <p>💸 Total de Saídas: <strong><?= number_format($total_saidas, 2, ',', '.') ?> Kz</strong></p>
        <p>🧾 Saldo Atual: <strong><?= number_format($saldo, 2, ',', '.') ?> Kz</strong></p>
    </div>

</div>

</body>
</html>
