<?php
include 'conexao.php';
session_start();

// Buscar turmas
$turmas = [];
$res = $conn->query("SELECT id, nome, classe, curso, turno FROM turmas ORDER BY nome");
while ($row = $res->fetch_assoc()) {
    $turmas[] = $row;
}

// Verificar se uma turma foi selecionada
$alunos = [];
if (isset($_GET['turma_id'])) {
    $turma_id = intval($_GET['turma_id']);
    
    // Buscar alunos da turma
    $stmt = $conn->prepare("SELECT id, numero, nome, idade, genero FROM alunos WHERE turma_id = ? ORDER BY numero ASC");
    $stmt->bind_param("i", $turma_id);
    $stmt->execute();
    $alunos = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Ver Turmas</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        h2 { margin-top: 40px; }
        .turma-btn {
            padding: 10px 15px;
            margin: 5px;
            background-color: #007BFF;
            color: white;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            display: inline-block;
        }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { padding: 10px; border: 1px solid #ccc; text-align: left; }
        .acoes {
            text-align: center;
            white-space: nowrap;
        }
        .btn-acao {
            padding: 5px 10px;
            margin: 2px;
            border: none;
            border-radius: 4px;
            text-decoration: none;
            color: white;
            font-size: 14px;
            display: inline-block;
            cursor: pointer;
        }
        .alterar { background-color: #007BFF; }
        .remover { background-color: #DC3545; }
        .btn-acao:hover { opacity: 0.8; }
        .nome-link {
            text-decoration: underline;
            color: #007BFF;
            cursor: pointer;
        }
        .nome-link:hover {
            color: #0056b3;
        }
    </style>
</head>
<body>

<h1>Selecione uma Turma</h1>
<?php foreach ($turmas as $turma): ?>
    <div style="margin-bottom: 10px;">
        <strong><?= htmlspecialchars($turma['nome'] . ' ' . $turma['classe'] . ' ' . $turma['curso'] . ' (' . $turma['turno'] . ')') ?></strong><br>
        <a class="turma-btn" href="?turma_id=<?= $turma['id'] ?>">Ver Lista Nominal</a>
        <a class="turma-btn" style="background-color: green;" href="lista_alunos_turma.php?turma_id=<?= $turma['id'] ?>" target="_blank">Imprimir Lista Nominal</a>
    </div>
<?php endforeach; ?>

<?php if ($alunos): ?>
    <h2>Lista de Alunos da Turma</h2>
    <table>
        <thead>
            <tr>
                <th>Nº</th>
                <th>Nome</th>
                <th>Idade</th>
                <th>Género</th>
                <th class="acoes">Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($alunos as $aluno): ?>
                <tr>
                    <td><?= htmlspecialchars($aluno['numero']) ?></td>
                    <td>
                        <a href="editar_aluno.php?id=<?= $aluno['id'] ?>" class="nome-link">
                            <?= htmlspecialchars($aluno['nome']) ?>
                        </a>
                    </td>
                    <td><?= htmlspecialchars($aluno['idade']) ?></td>
                    <td><?= htmlspecialchars($aluno['genero']) ?></td>
                    <td class="acoes">
                        <a href="alterar_aluno.php?id=<?= $aluno['id'] ?>&turma_id=<?= $turma_id ?>" class="btn-acao alterar">Alterar</a>
                        <a href="#" onclick="confirmarRemocao(<?= $aluno['id'] ?>, '<?= addslashes($aluno['nome']) ?>', <?= $turma_id ?>)" class="btn-acao remover">Remover</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<div style="text-align: center; margin-top: 20px;">
    <a href="painel_secretaria_geral.php" class="btn" style="background: #28a745; margin-left: 10px; text-decoration: none; display: inline-block; padding: 10px 25px; border-radius: 5px; color: white;">Voltar ao Painel</a>
</div>

<script>
function confirmarRemocao(alunoId, alunoNome, turmaId) {
    if (confirm("Tem certeza que deseja remover o aluno '" + alunoNome + "'? Esta ação não pode ser desfeita.")) {
        window.location.href = "remover_aluno.php?id=" + alunoId + "&turma_id=" + turmaId;
    }
}
</script>

</body>
</html>