<?php
include 'conexao.php';

// Inicializar array de grupos (curso + nome da turma)
$grupos = [];

$sql = "
  SELECT DISTINCT 
    a.curso, 
    t.nome AS turma 
  FROM novos_alunos a
  JOIN turmas t ON a.turma_id = t.id
  WHERE a.obs = 'Admitido'
  ORDER BY a.curso, t.nome
";

$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $grupos[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Turmas dos Alunos Admitidos</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f5f5f5;
      padding: 20px;
    }
    h2 {
      color: #003366;
      text-align: center;
    }
    h3 {
      margin-top: 40px;
      background: #003366;
      color: white;
      padding: 10px;
      border-radius: 6px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
      background: white;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    th, td {
      border: 1px solid #ccc;
      padding: 8px;
      text-align: center;
    }
    th {
      background-color: #007bff;
      color: white;
    }
    td.nome {
      text-align: left;
    }
    .botao-voltar {
      margin-bottom: 20px;
      display: inline-block;
      background: #007bff;
      color: white;
      padding: 10px 20px;
      border-radius: 6px;
      text-decoration: none;
    }
    .botao-voltar:hover {
      background: #0056b3;
    }
  </style>
</head>
<body>

<a href="painel_secretaria_geral.php" class="botao-voltar"><i class="fas fa-arrow-left"></i> Voltar ao Painel</a>

<h2>Turmas dos Alunos Admitidos</h2>

<?php
if (!empty($grupos)) {
    foreach ($grupos as $grupo) {
        $curso = $grupo['curso'];
        $turma = $grupo['turma'];

        // Buscar alunos dessa turma
        $stmt = $conn->prepare("
          SELECT a.nome, a.idade, a.genero 
          FROM novos_alunos a
          JOIN turmas t ON a.turma_id = t.id
          WHERE a.curso = ? AND t.nome = ? AND a.obs = 'Admitido'
          ORDER BY a.nome ASC
        ");
        $stmt->bind_param("ss", $curso, $turma);
        $stmt->execute();
        $alunos = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
        $stmt->close();

        echo "<h3>Curso: <strong>$curso</strong> | Turma: <strong>$turma</strong></h3>";
        echo "<table>
                <tr>
                  <th>Nº</th>
                  <th>Nome</th>
                  <th>Idade</th>
                  <th>Género</th>
                </tr>";
        $n = 1;
        foreach ($alunos as $al) {
            echo "<tr>
                    <td>$n</td>
                    <td class='nome'>" . htmlspecialchars($al['nome']) . "</td>
                    <td>" . htmlspecialchars($al['idade']) . "</td>
                    <td>" . htmlspecialchars($al['genero']) . "</td>
                  </tr>";
            $n++;
        }
        echo "</table>";
    }
} else {
    echo "<p style='color:red;'>Nenhuma turma com alunos admitidos encontrada.</p>";
}
?>

</body>
</html>
