<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    http_response_code(403);
    exit("Acesso negado");
}

$aluno_id = intval($_POST['aluno_id'] ?? 0);
$turma_id = intval($_POST['turma_id'] ?? 0);

if ($aluno_id <= 0 || $turma_id <= 0) {
    http_response_code(400);
    exit("Parâmetros inválidos");
}

// Buscar todas as disciplinas da turma
$res = $conn->query("SELECT id FROM disciplinas WHERE turma_id = $turma_id");
$disciplinas = [];
while ($row = $res->fetch_assoc()) {
    $disciplinas[] = $row['id'];
}

// Atualizar todas as notas da disciplina para este aluno (apenas MF)
foreach ($disciplinas as $disciplina_id) {
    // Atualiza para todos os 3 trimestres
    for ($t = 1; $t <= 3; $t++) {
        $stmt = $conn->prepare("UPDATE notas SET mac1=10, mac2=10, mac3=10, npt=10, exame=10 WHERE aluno_id=? AND disciplina_id=? AND turma_id=? AND trimestre=?");
        $stmt->bind_param("iiii", $aluno_id, $disciplina_id, $turma_id, $t);
        $stmt->execute();
    }
}

// Atualizar observação do aluno (se estiver numa tabela específica)
$stmt = $conn->prepare("UPDATE alunos SET observacao = 'TRANSITA' WHERE id = ?");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();

echo "ok";
?>
